// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Properties/hkDefaultPropertyBag.h>
#include <Common/Base/Types/Properties/hkPropertyRegistry.h>

bool hkDefaultPropertyBag::isEmpty() const
{
    return m_propertyMap.getSize() == 0 && m_transientPropertyMap.getSize() == 0;
}

int hkDefaultPropertyBag::getSize() const
{
    return m_propertyMap.getSize() + m_transientPropertyMap.getSize();
}

bool hkDefaultPropertyBag::hasProperty(hkPropertyId id) const
{
    return getMap(id).hasKey(id);
}

hkDefaultPropertyBag::HashMap& hkDefaultPropertyBag::getMap(hkPropertyId id)
{
    return id.desc()->isSerialized() ? m_propertyMap : m_transientPropertyMap;
}

const hkDefaultPropertyBag::HashMap& hkDefaultPropertyBag::getMap(hkPropertyId id) const
{
    return id.desc()->isSerialized() ? m_propertyMap : m_transientPropertyMap;
}

const hkDefaultPropertyBag::HashMap::Item& hkDefaultPropertyBag::atIndex(int i) const
{
    const int mapSize = m_propertyMap.getSize();
    if (i < mapSize)
    {
        return m_propertyMap.viewItems()[i];
    }
    else
    {
        return m_transientPropertyMap.viewItems()[i - mapSize];
    }
}

//
//  Adds a property with a unique name (type + name = unique ID)

hkResult hkDefaultPropertyBag::addChecked(hkPropertyId id, const hkReflect::Var& var)
{
    HK_ASSERT_IMPLEMENTATION(0, m_locked == false, "Cannot add properties to project settings here");
    // We'd like to be able to assert( var.getType()->equals(id.desc()->type)
    // But the types don't need to be equal as long as they are assignable.

    HashMap& map = getMap(id);

    HashMap::Iterator it = map.findOrInsertKey(id, hkReflect::Any());
    hkReflect::Any& any = map.getValue(it);
    if (any.containsObject() == false)
    {
        any.init(id.desc()->type);
    }

    return any.var().assign(var);
}

//
//  Removes the property associated with the given id
hkResult hkDefaultPropertyBag::removeChecked(hkPropertyId id)
{
    HK_ASSERT_IMPLEMENTATION(0, m_locked == false, "Cannot add properties to project settings here");
    return getMap(id).remove(id);
}

_Ret_maybenull_
void* hkDefaultPropertyBag::getValueAddressChecked(_In_ const hkReflect::Type* type, hkPropertyId id) const
{
    HK_ASSERT(0x14d5ecc5, type->equals(id.desc()->type), "Requested type does not match the type in hkPropertyId");

    const HashMap& map = getMap(id);
    HashMap::Iterator it = map.find(id);
    if (map.isValid(it))
    {
        const hkReflect::Any& any = map.getValue(it);
        HK_ASSERT(0x1df3726d, type->equals(any.var().getType()), "Requested type does not match the property value");
        return any.var().getAddress();
    }
    return HK_NULL;
}


//
//  Copies cloneable properties from src map to this property bag

void hkDefaultPropertyBag::copyProperties(const hkDefaultPropertyBag& other)
{
    HK_ASSERT_NO_MSG(0x6895eb8, this != &other);

    copyProperties(other.m_propertyMap);
    copyProperties(other.m_transientPropertyMap);
}

//  Copies cloneable properties from src map to this property bag

void hkDefaultPropertyBag::copyProperties(const HashMap& src)
{
    for (Iterator it = src.getIterator(); src.isValid(it); it = src.getNext(it))
    {
        const hkPropertyId& pId = src.getKey(it);

        if (!pId.desc() || !pId.desc()->isCloneable())
        {
            continue;
        }

        // Remove our property
        removeChecked(pId);

        // Add the property from the given object
        addChecked(pId, src.getValue(it).var());
    }
}

void hkDefaultPropertyBag::hackAfterReflectNew()
{
    m_propertyMap.afterReflectNew();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
