// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// Stores step delta time and inverse delta time for simulation step.
class HK_EXPORT_COMMON hkStepInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, hkStepInfo );

        HK_INLINE hkStepInfo() {}

        HK_INLINE hkStepInfo( hkTime startTime, hkTime endTime )
        {
            set( startTime, endTime );
        }

        void set( hkTime startTime, hkTime endTime );

    public:

            /// The time at the start of the integration step.
        HK_ALIGN16( hkTime m_startTime );

            /// The time at the end of the integration step
        hkTime m_endTime;

            /// the current time step being simulated
        hkReal m_deltaTime;

            /// the inverse of the current time step being simulated
        hkReal m_invDeltaTime;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
