// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// Simple structure to contain information about vertex arrays.
struct HK_EXPORT_COMMON hkStridedVertices
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, hkStridedVertices );

    /// Initialize as empty
    HK_ALWAYS_INLINE hkStridedVertices() : m_numVertices(0) {}

    /// Initialize with an array of hkVector4
    HK_ALWAYS_INLINE hkStridedVertices( const hkArrayBase<hkVector4>& vertices ) { set(vertices); }
    HK_ALWAYS_INLINE hkStridedVertices(hkArrayView<const hkVector4> vertices) { set(vertices); }

    /// Initialize with a pointer to hkVector4
    HK_ALWAYS_INLINE hkStridedVertices( _In_reads_(count) const hkVector4* vertices, int count ) { set(vertices,count); }

    /// Return the number of vertices.
    HK_INLINE int getSize() const { return(m_numVertices); }

    /// Retrieve a vertex
    HK_INLINE void getVertex( int index, hkVector4& vertexOut ) const
    {
        HK_ASSERT( 0x15625423, index >= 0 && index < m_numVertices, "Index out of range" );
        const hkReal* pv = (const hkReal*)( ((const hkUint8*)m_vertices) + m_striding*index );
        vertexOut.set( pv[0], pv[1], pv[2], m_striding >= (int)sizeof(hkVector4) ? pv[3] : 0 );
    }

    HK_INLINE void getVertex(int index, _Out_writes_all_(3) hkReal* vertexOut) const
    {
        HK_ASSERT_DEV(0x15625423, index >= 0 && index < m_numVertices, "Index out of range");
        const hkReal* pv = (const hkReal*)(((const hkUint8*)m_vertices) + m_striding*index);
        vertexOut[0] = pv[0];
        vertexOut[1] = pv[1];
        vertexOut[2] = pv[2];
    }

    HK_ALWAYS_INLINE void set(hkArrayView<const hkVector4> vertices)
    {
        set( vertices.begin(), vertices.getSize() );
    }

    HK_ALWAYS_INLINE void set(hkArrayBase<hkVector4> const& vertices)
    {
        set(vertices.begin(), vertices.getSize());
    }

    template <typename T>
    inline void set(_In_reads_(numVertices) const T* vertices, int numVertices)
    {
        HK_ASSERT_NO_MSG( 0x75cf3975, sizeof(T) >= sizeof(hkReal)*3 );
        m_vertices      = (const hkReal*)vertices;
        m_numVertices   = numVertices;
        m_striding      = sizeof(T);
    }

public:

    /// Pointer to the array of vertices
    const hkReal* m_vertices;

    /// The number of vertices in the array.
    int m_numVertices;

    /// The striding is the byte difference between one float triple
    /// and the next float triple (so usually 12 or 16 or greater).
    int m_striding;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
