// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// A sphere defined by a center and radius.
class HK_EXPORT_COMMON hkSphere
{
    public:

        HK_DECLARE_CLASS(hkSphere, New, Reflect);

            /// Creates an arbitrary sphere with given center and radius.
            /// The sphere class is a utility class for storing information representing a
            /// sphere. This constructor creates a sphere with the given center and radius.
            /// \param pt Center of the sphere
            /// \param radius Radius of the sphere
        HK_INLINE hkSphere();

        ~hkSphere() {}

            /// Creates an arbitrary sphere with given center and radius.
        inline hkSphere(const hkVector4& pt, hkReal radius);
        inline hkSphere(hkVector4Parameter pt, hkSimdRealParameter radius);

            /// This function returns the radius of the sphere.
        inline hkReal getRadius() const;
        inline hkSimdReal getRadiusSimdReal() const;

            /// This function changes the radius of the sphere.
            /// \param newRadius The new radius
        inline void setRadius(hkReal newRadius);
        inline void setRadius(hkSimdRealParameter newRadius);

            /// Returns the position of the center of the sphere.
        inline const hkVector4& getPosition() const;

            /// Returns the center of the sphere, the .w is the radius
        inline const hkVector4& getPositionAndRadius() const;

            /// Returns the center of the sphere, the .w is the radius
        inline hkVector4& getPositionAndRadius();

            /// This function changes the position of the center of the sphere.
            /// \param newPos The desired center of the sphere
        inline void setPosition(const hkVector4& newPos);

            /// Same as setPosition, using the hkVector4's w component as the radius.
        inline void setPositionAndRadius( const hkVector4& newPos );

            /// Same as setPosition and setRadius, more efficient
        inline void setPositionAndRadius( hkVector4Parameter newPos, hkSimdRealParameter newRadius );

    protected:

        hkVector4 m_pos;        // note: the w part is the radius
};

#include <Common/Base/Types/Geometry/Sphere/hkSphere.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
