// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename Storage> hkRect<Storage>::hkRect()
{
}

template<typename Storage> hkRect<Storage>::hkRect(Storage x, Storage y, Storage width, Storage height)
    : m_x(x), m_y(y), m_width(width), m_height(height)
{
}

template<typename Storage> Storage hkRect<Storage>::getX() const
{
    return m_x;
}

template<typename Storage> void hkRect<Storage>::setX(Storage value)
{
    m_x = value;
}

template<typename Storage> Storage hkRect<Storage>::getY() const
{
    return m_y;
}

template<typename Storage> void hkRect<Storage>::setY(Storage value)
{
    m_y = value;
}

template<typename Storage> Storage hkRect<Storage>::getX2() const
{
    return m_x + m_width;
}

template<typename Storage> Storage hkRect<Storage>::getY2() const
{
    return m_y + m_height;
}

template<typename Storage> Storage hkRect<Storage>::getWidth() const
{
    return m_width;
}

template<typename Storage> void hkRect<Storage>::setWidth(Storage value)
{
    m_width = value;
}

template<typename Storage> Storage hkRect<Storage>::getHeight() const
{
    return m_height;
}

template<typename Storage> void hkRect<Storage>::setHeight(Storage value)
{
    m_height = value;
}

template<typename Storage> void hkRect<Storage>::getPosition(Storage& x, Storage& y) const
{
    x = m_x;
    y = m_y;
}

template<typename Storage> void hkRect<Storage>::getSize(Storage& width, Storage& height) const
{
    width = m_width;
    height = m_height;
}

// Sets the position of the rectangle
template<typename Storage> void hkRect<Storage>::setPosition(const Storage x, const Storage y)
{
    m_x = x;
    m_y = y;
}

// Sets the size of the rectangle
template<typename Storage> void hkRect<Storage>::setSize(const Storage width, const Storage height)
{
    m_width = width;
    m_height = height;
}


// Returns true if the rectangle has a non zero area
template<typename Storage> bool hkRect<Storage>::hasNonZeroArea() const
{
    return (m_width > 0) && (m_height > 0);
}

// Returns true if the rectangle has a zero area
template<typename Storage> bool hkRect<Storage>::hasZeroArea() const
{
    return (m_width == 0) || (m_height == 0);
}

template<typename Storage> bool hkRect<Storage>::operator == (const hkRect& other) const
{
    return m_width == other.m_width && m_height == other.m_height && m_x == other.m_x && m_y == other.m_y;
}

// Returns if the two rectangles are not the same (origin and/or size differ)
template<typename Storage> bool hkRect<Storage>::operator != (const hkRect& other) const
{
    return m_width != other.m_width || m_height != other.m_height || m_x != other.m_x || m_y != other.m_y;
}


template<typename Storage>
void hkRect<Storage>::translate(const Storage x, const Storage y)
{
    HK_ASSERT_NO_MSG(0x7c5f5d8f, isValid());
    m_x += x;
    m_y += y;
}


template<typename Storage>
hkRect<Storage> hkRect<Storage>::getTranslated(const Storage x, const Storage y) const
{
    return hkRect<Storage>(x + m_x, y + m_y, getWidth(), getHeight());
}


template<typename Storage>
void hkRect<Storage>::transform(const Storage scaleX, const Storage scaleY, const Storage ofsX, const Storage ofsY)
{
    m_x = m_x * scaleX + ofsX;
    m_y = m_y * scaleY + ofsY;

    // Scale in x, and ensure mirroring still produces a valid rect
    m_width *= scaleX;
    if (scaleX < 0)
    {
        m_x += m_width;
        m_width = -m_width;
    }

    // Scale in y, and ensure mirroring still produces a valid rect
    m_height *= scaleY;
    if (scaleY < 0)
    {
        m_y += m_height;
        m_height = -m_height;
    }
}


template<typename Storage>
hkRect<Storage> hkRect<Storage>::getTransformed(const Storage scaleX, const Storage scaleY, const Storage ofsX, const Storage ofsY) const
{
    return hkRect<Storage>(m_x*scaleX + ofsX, m_y*scaleY + ofsY, getWidth()*scaleX, getHeight()*scaleY);
}


template<typename Storage>
bool hkRect<Storage>::containsPoint(Storage x, Storage y) const
{
    // Border points are considered inside to be consistent with hkAABB behavior.
    return x >= getX() && y >= getY() && x <= getX2() && y <= getY2();
}

template<typename Storage>
bool hkRect<Storage>::overlaps(const hkRect<Storage> &other) const
{
    if (getX() > other.getX2() || getX2() < other.getX() ||
        getY() > other.getY2() || getY2() < other.getY())
        return false;
    return true;
}

template<typename Storage>
bool hkRect<Storage>::contains(const hkRect<Storage> &other) const
{
    return other.getX() >= getX() && other.getY() >= getY() && other.getX2() <= getX2() && other.getY2() <= getY2();
}

template<typename Storage>
bool hkRect<Storage>::contains(Storage x, Storage y)const
{
    return (x >= getX()
         && y >= getY()
         && x <= getX2()
         && y <= getY2());
}


template<typename Storage>
void hkRect<Storage>::setUnion(const hkRect<Storage> &rect0, const hkRect<Storage> &rect1)
{
    Storage x1 = hkMath::min2(rect0.getX(), rect1.getX());
    Storage y1 = hkMath::min2(rect0.getY(), rect1.getY());
    Storage x2 = hkMath::max2(rect0.getX2(), rect1.getX2());
    Storage y2 = hkMath::max2(rect0.getY2(), rect1.getY2());
    setPosition(x1, y1);
    setSize(x2 - x1, y2 - y1);
}

template<typename Storage>
void hkRect<Storage>::setIntersection(const hkRect<Storage> &rect0, const hkRect<Storage> &rect1)
{
    Storage x1 = hkMath::max2(rect0.getX(), rect1.getX());
    Storage y1 = hkMath::max2(rect0.getY(), rect1.getY());
    Storage x2 = hkMath::min2(rect0.getX2(), rect1.getX2());
    Storage y2 = hkMath::min2(rect0.getY2(), rect1.getY2());
    setPosition(x1, y1);
    setSize(x2 - x1, y2 - y1);
}

template<typename Storage>
void hkRect<Storage>::expandby(Storage border)
{
    HK_ASSERT_NO_MSG(0x2ce4cb70, isValid());
    m_x -= border; m_y -= border;
    m_width += border * 2;
    m_height += border * 2;
}

template<typename Storage>
void hkRect<Storage>::includeRect(const hkRect<Storage> &other)
{
    Storage x2 = getX2();
    Storage y2 = getY2();
    m_x = hkMath::min2(m_x, other.getX());
    m_y = hkMath::min2(m_y, other.getY());
    m_width = hkMath::max2(x2, other.getX2()) - m_x;
    m_height = hkMath::max2(y2, other.getY2()) - m_y;
}

template<typename Storage>
void hkRect<Storage>::includePoint(Storage x, Storage y)
{
    Storage x2 = getX2();
    Storage y2 = getY2();
    m_x = hkMath::min2(m_x, x);
    m_y = hkMath::min2(m_y, y);
    m_width = hkMath::max2(x2, x) - m_x;
    m_height = hkMath::max2(y2, y) - m_y;
}

template<typename Storage>
void hkRect<Storage>::clampToBounds(Storage &x, Storage &y) const
{
    HK_ASSERT_NO_MSG(0x63586bd0, isValid());
    x = hkMath::clamp(x, getX(), getX2());
    y = hkMath::clamp(y, getY(), getY2());
}

template<typename Storage>
bool hkRect<Storage>::clip(const hkRect& bounds, Storage margin /*= Storage(0)*/)
{
    Storage clipMinX = bounds.getX() + margin;
    Storage clipMaxX = bounds.getX2() - margin;
    Storage clipMinY = bounds.getY() + margin;
    Storage clipMaxY = bounds.getY2() - margin;

    Storage minX = getX();
    Storage maxX = getX2();
    Storage minY = getY();
    Storage maxY = getY2();

    // Only clamp each edge in one direction. This is used below to determine whether
    // the clipped rect overlapped the bounds at all.
    if (minX < clipMinX)
        minX = clipMinX;
    if (minY < clipMinY)
        minY = clipMinY;
    if (maxX > clipMaxX)
        maxX = clipMaxX;
    if (maxY > clipMaxY)
        maxY = clipMaxY;

    setFromMinMax(minX, minY, maxX, maxY);

    // If clipping produces an invalid rect, the original rect did not overlap the bounds.
    return isValid();
}

template<typename Storage>
inline bool hkRect<Storage>::isValid() const
{
    return
        ( m_width >= 0
            && m_height >= 0
            && hkMath::isFinite( hkReal( m_x ) )
            && hkMath::isFinite( hkReal( m_y ) )
            && hkMath::isFinite( hkReal( m_width ) )
            && hkMath::isFinite( hkReal( m_height ) ) );
}

template<>
inline bool hkRect<hkFloat32>::isValid() const
{
    return
        ( m_width >= 0
            && m_height >= 0
            && hkMath::isFinite( m_x )
            && hkMath::isFinite( m_y )
            && hkMath::isFinite( m_width )
            && hkMath::isFinite( m_height ) );
}

template<>
inline bool hkRect<hkDouble64>::isValid() const
{
    return
        ( m_width >= 0
            && m_height >= 0
            && hkMath::isFinite( m_x )
            && hkMath::isFinite( m_y )
            && hkMath::isFinite( m_width )
            && hkMath::isFinite( m_height ) );
}

template<typename Storage>
hkBool32 hkRect<Storage>::equals(const hkRect<Storage>& other) const
{
    return (m_x == other.m_x
        && m_y == other.m_y
        && m_width == other.m_width
        && m_height == other.m_height);
}

template<typename Storage>
void hkRect<Storage>::setInvalid()
{
    Storage largeNumber = hkTrait::NumericLimits<Storage>::maxValue();
    m_x = m_y = largeNumber / 2; // otherwise x2,y2 is zero
    m_width = m_height = -largeNumber;
}

template<typename Storage>
void hkRect<Storage>::setZero()
{
    m_x = m_y = 0;
    m_width = m_height = 0;
}

/// Set from center and radius.
template<typename Storage>
void hkRect<Storage>::setFromMinMax(Storage minX, Storage minY, Storage maxX, Storage maxY)
{
    m_x = minX;
    m_y = minY;
    m_width = maxX - minX;
    m_height = maxY - minY;
}

/// Set from center and radius.
template<typename Storage>
void hkRect<Storage>::setFromPositionSize(Storage x, Storage y, Storage width, Storage height)
{
    m_x = x;
    m_y = y;
    m_width = width;
    m_height = height;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
