// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


    /// A rect defined by a position and size.
template<typename Storage> class hkRect
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkRect);
        HK_DECLARE_POD_TYPE_IF_POD(Storage);
        HK_DECLARE_REFLECTION();

            /// Creates an uninitialized rectangle.
        inline hkRect();

            /// Creates an arbitrary rect with given position and size.
        inline hkRect(Storage x, Storage y, Storage width, Storage height);

        /// Sets values so that position is a large value and size is a large negative value. The passed large number value is type specific (e.g. HK_FLOAT_MAX for float)
        inline void setInvalid();

        /// Sets position and size to zero
        inline void setZero();

        /// Set from min and max points
        inline void setFromMinMax(Storage minX, Storage minY, Storage maxX, Storage maxY);
        // Indicates whether one of the rectangle's dimension is < 0. A width and height of 0 is a non-empty rectangle (see also hasNonZeroArea)
        /// Set (min) position and size
        inline void setFromPositionSize(Storage x, Storage y, Storage width, Storage height);

        /// Valid rects have no NaNs and non-negative size.
        inline bool isValid() const;

        /// Returns true if the rects are strictly equal
        inline hkBool32 equals(const hkRect<Storage>& other) const;

        /// This function returns the x position of the rect.
        inline Storage getX() const;

        /// This function sets the x position of the rect.
        inline void setX(Storage value);

        /// This function returns the y position of the rect.
        inline Storage getY() const;

        /// This function sets the y position of the rect.
        inline void setY(Storage value);

        /// Returns the x coordinate of the other corner of the rect, i.e. getX() + getWidth().
        inline Storage getX2() const;

        /// Returns the y coordinate of the other corner of the rect, i.e. getY() + getHeight().
        inline Storage getY2() const;

            /// Stores the position of the rectangle in the given parameters
        inline void getPosition(Storage& x, Storage& y) const;

            /// Stores the size (width and height) of the rectangle in the given parameters
        inline void getSize(Storage& width, Storage& height) const;

            /// Sets the position of the rectangle
        inline void setPosition(const Storage x, const Storage y);

            /// Sets the size of the rectangle
        inline void setSize(const Storage width, const Storage height);

        /// Translates the position of this rectangle by given offset
        inline void translate(const Storage x, const Storage y);

        /// Returns a rectangle that is translated by the given offset
        inline hkRect<Storage> getTranslated(const Storage x, const Storage y) const;

        /// Applies scale and offset
        inline void transform(const Storage scaleX, const Storage scaleY, const Storage ofsX, const Storage ofsY);

        /// Returns a new rectangle with scale and offset applied
        inline hkRect<Storage> getTransformed(const Storage scaleX, const Storage scaleY, const Storage ofsX, const Storage ofsY) const;

            /// Returns true if the rectangle has a non zero area
        inline bool hasNonZeroArea() const;

            /// Returns true if the rectangle has a zero area
        inline bool hasZeroArea() const;

        /// This function returns the width of the rect.
        inline Storage getWidth() const;

        /// This function sets the width of the rect.
        inline void setWidth(Storage value);

        /// This function returns the height of the rect.
        inline Storage getHeight() const;

        /// This function sets the width of the rect.
        inline void setHeight(Storage value);

        /// Expands this rect to include the passed position
        inline void includePoint(Storage x, Storage y);

        /// Expands this rect to include the passed rectangle
        inline void includeRect(const hkRect<Storage> &other);

        /// Expands this rect by the passed border in all 4 directions
        inline void expandby(Storage border);

        /// Sets this rect to the intersection of the passed two source rectangles. The result may cause isEmpty() to return true if the source rects do not overlap
        inline void setIntersection(const hkRect<Storage> &rect0, const hkRect<Storage> &rect1);

        /// Sets this rect to the union of the passed two source rectangles.
        inline void setUnion(const hkRect<Storage> &rect0, const hkRect<Storage> &rect1);

        /// Clamps the passed coordinates to the bounds of this rectangle
        inline void clampToBounds(Storage &x, Storage &y) const;

        /// Adjust this rect's position and size to ensure it is fully contained within the bounds
        /// rect reduced by the margin in all directions. If this produces an invalid rect (indicating,
        /// there is no overlap with the bounds rect), this function returns false.
        inline bool clip(const hkRect& bounds, Storage margin = Storage(0));

        // Returns true if the passed source rectangle is fully inside this rectangle. Boundaries are inclusive.
        inline bool contains(const hkRect<Storage> &other) const;

        // Returns true if the passed point is fully inside this rectangle. Boundaries are inclusive.
        inline bool contains(Storage x, Storage y) const;

        // Returns true if the passed source rectangle overlaps with this rectangle. Boundaries are inclusive.
        inline bool overlaps(const hkRect<Storage> &other) const;

        // Returns true if the passed position is inside this rectangle. Boundaries are inclusive.
        inline bool containsPoint(Storage x, Storage y) const;

        /// Indicates whether the two rectangles are the same (origin and size)
        inline bool operator == (const hkRect& other) const;

        /// Indicates whether the two rectangles are not the same (origin and/or size differ)
        inline bool operator != (const hkRect& other) const;

    protected:

        Storage m_x;
        Storage m_y;

        Storage m_width;
        Storage m_height;

};

#include <Common/Base/Types/Geometry/Rect/hkRect.inl>
#include <Common/Base/_Auto/TemplateTypes/hkRect_Types.inl>

typedef hkRect<hkInt16> hkRect16;
typedef hkRect<hkInt32> hkRect32;
typedef hkRect<hkReal> hkRectR;
typedef hkRect<hkFloat32> hkRectF;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
