// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename Storage> hkPoint2d<Storage>::hkPoint2d()
{
}

template<typename Storage> hkPoint2d<Storage>::hkPoint2d(Storage x, Storage y)
    : m_x(x), m_y(y)
{
}

template<typename Storage> Storage hkPoint2d<Storage>::getX() const
{
    return m_x;
}

template<typename Storage> Storage hkPoint2d<Storage>::getY() const
{
    return m_y;
}

template<typename Storage> void hkPoint2d<Storage>::set(const Storage x, const Storage y)
{
    m_x = x;
    m_y = y;
}

template<typename Storage> void hkPoint2d<Storage>::setX(const Storage x)
{
    m_x = x;
}

template<typename Storage> void hkPoint2d<Storage>::setY(const Storage y)
{
    m_y = y;
}

template<typename Storage>  bool hkPoint2d<Storage>::operator == (const hkPoint2d& other) const
{
    return (m_x == other.m_x) && (m_y ==  other.m_y);
}

template<typename Storage>  bool hkPoint2d<Storage>::operator != (const hkPoint2d& other) const
{
    return (m_x != other.m_x) || (m_y != other.m_y);
}

template<typename Storage>  bool hkPoint2d<Storage>::isAtOrigin() const
{
    return (m_x == 0) && (m_y == 0);
}





template<typename Storage> hkPoint3d<Storage>::hkPoint3d()
{
}

template<typename Storage> hkPoint3d<Storage>::hkPoint3d(Storage x, Storage y, Storage z)
    : m_x(x), m_y(y), m_z(z)
{
}

template<typename Storage> Storage hkPoint3d<Storage>::getX() const
{
    return m_x;
}

template<typename Storage> Storage hkPoint3d<Storage>::getY() const
{
    return m_y;
}

template<typename Storage> Storage hkPoint3d<Storage>::getZ() const
{
    return m_z;
}

template<typename Storage> void hkPoint3d<Storage>::set(const Storage x, const Storage y, const Storage z)
{
    m_x = x;
    m_y = y;
    m_z = z;
}

template<typename Storage> void hkPoint3d<Storage>::setX(const Storage x)
{
    m_x = x;
}

template<typename Storage> void hkPoint3d<Storage>::setY(const Storage y)
{
    m_y = y;
}

template<typename Storage> void hkPoint3d<Storage>::setZ(const Storage z)
{
    m_z = z;
}

template<typename Storage>  bool hkPoint3d<Storage>::operator == (const hkPoint3d& other) const
{
    return (m_x == other.m_x) && (m_y ==  other.m_y) && (m_z == other.m_z);
}

template<typename Storage>  bool hkPoint3d<Storage>::operator != (const hkPoint3d& other) const
{
    return (m_x != other.m_x) || (m_y != other.m_y) || (m_z != other.m_z);
}

template<typename Storage>  bool hkPoint3d<Storage>::isAtOrigin() const
{
    return (m_x == 0) && (m_y == 0) && (m_z == 0);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
