// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


/// Simple 2D point class
template<typename Storage> class hkPoint2d
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkPoint2d);
        HK_DECLARE_REFLECTION();

        /// Creates an uninitialized point.
        inline hkPoint2d();

        /// Creates an arbitrary point with the given position.
        inline hkPoint2d(Storage x, Storage y);

        /// Returns the x coordinate of the point.
        inline Storage getX() const;

        /// Returns the y coordinate of the point.
        inline Storage getY() const;

        // Sets the position of the rectangle
        inline void set(const Storage x, const Storage y);

        // Sets the x coordinate of the point
        inline void setX(const Storage x);

        // Sets the y coordinate of the point
        inline void setY(const Storage y);

        // Does a component wise comparison with another point
        inline bool operator == (const hkPoint2d& other) const;

        // Does a component wise comparison with another point
        inline bool operator != (const hkPoint2d& other) const;

        // Returns true if the point is at (0, 0), false otherwise
        inline bool isAtOrigin() const;

    protected:

        Storage m_x;
        Storage m_y;

};


/// Simple 3D point class
template<typename Storage> class hkPoint3d
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkPoint3d);
    HK_DECLARE_REFLECTION();

    /// Creates an uninitialized point.
    inline hkPoint3d();

    /// Creates an arbitrary point with the given position.
    inline hkPoint3d(Storage x, Storage y, Storage z);

    /// Returns the x coordinate of the point.
    inline Storage getX() const;

    /// Returns the y coordinate of the point.
    inline Storage getY() const;

    /// Returns the z coordinate of the point.
    inline Storage getZ() const;

    // Sets the position of the rectangle
    inline void set(const Storage x, const Storage y, const Storage z);

    // Sets the x coordinate of the point
    inline void setX(const Storage x);

    // Sets the y coordinate of the point
    inline void setY(const Storage y);

    // Sets the z coordinate of the point
    inline void setZ(const Storage z);

    // Does a component wise comparison with another point
    inline bool operator == (const hkPoint3d& other) const;

    // Does a component wise comparison with another point
    inline bool operator != (const hkPoint3d& other) const;

    // Returns true if the point is at (0, 0, 0), false otherwise
    inline bool isAtOrigin() const;

protected:

    Storage m_x;
    Storage m_y;
    Storage m_z;

};


#include <Common/Base/Types/Geometry/Point/hkPoint.inl>
#include <Common/Base/_Auto/TemplateTypes/hkPoint_Types.inl>

typedef hkPoint2d<hkInt16> hkPoint2d16;
typedef hkPoint2d<hkInt32> hkPoint2d32;
typedef hkPoint2d<hkReal> hkPoint2dR;

typedef hkPoint3d<hkInt16> hkPoint3d16;
typedef hkPoint3d<hkInt32> hkPoint3d32;
typedef hkPoint3d<hkReal> hkPoint3dR;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
