// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once



/// Stores a plane
struct HK_EXPORT_COMMON hkPlane
{
    public:

        HK_DECLARE_CLASS(hkPlane, New, Reflect, Pod);

        /// Creates a new plane so that all three given points lay on that new plane.
        static hkPlane fromPoints( hkVector4Parameter p1, hkVector4Parameter p2, hkVector4Parameter p3 );

        /// Creates a new plane so that the given point lays on the plane and the plane normal is equal to normal
        static hkPlane fromPointAndNormal( hkVector4Parameter point, hkVector4Parameter normal );

        /// Returns the distance from the point to the plane
        HK_INLINE hkSimdReal planePointDistance(hkVector4Parameter point) const;

        HK_INLINE void normalize();

        HK_INLINE hkSimdReal getDistance() const;

        static hkResult intersectThreePlanes( const hkPlane& p0, const hkPlane& p1, const hkPlane& p2, hkVector4& result );

        // ax + by + cz + d = 0, can be evaluated using equation.dot4xyz1(point)
        hkVector4 m_equation;
};

#include <Common/Base/Types/Geometry/Plane/hkPlane.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
