// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Plane/hkPlane.h>

hkResult hkPlane::intersectThreePlanes( const hkPlane& p0, const hkPlane& p1, const hkPlane& p2, hkVector4& result )
{
    hkVector4 n0; n0.setXYZ(p0.m_equation);
    hkVector4 n1; n1.setXYZ(p1.m_equation);
    hkVector4 n2; n2.setXYZ(p2.m_equation);

    hkVector4 t;
    t.setCross(n1, n2);
    const hkSimdReal det = n0.dot<3>(t);

    if(det.isEqualZero())
        return HK_FAILURE;

    hkVector4 n1n2; n1n2.setCross(n1, n2); n1n2.mul(-p0.getDistance());
    hkVector4 n2n0; n2n0.setCross(n2, n0); n2n0.mul(-p1.getDistance());
    hkVector4 n0n1; n0n1.setCross(n0, n1); n0n1.mul(-p2.getDistance());

    result.setZero();
    result.add(n1n2);
    result.add(n2n0);
    result.add(n0n1);
    result.mul(hkSimdReal_1 / det);

    return HK_SUCCESS;
}

hkPlane hkPlane::fromPoints( hkVector4Parameter p0, hkVector4Parameter p1, hkVector4Parameter p2 )
{
    hkPlane result;
    hkVector4 p0p1, p0p2;
    p0p1.setSub( p1, p0 );
    p0p2.setSub( p2, p0 );
    result.m_equation.setCross( p0p1, p0p2 );
    result.m_equation.normalize<3>();
    hkSimdReal distance = result.m_equation.dot<3>( p0 );
    distance.mul( hkSimdReal_Minus1 );
    result.m_equation.setComponent<3>( distance );
    return result;
}

hkPlane hkPlane::fromPointAndNormal( hkVector4Parameter point, hkVector4Parameter normal )
{
    hkPlane result;
    result.m_equation = normal;
    result.m_equation.normalize<3>();
    hkSimdReal distance = result.m_equation.dot<3>( point );
    distance.mul( hkSimdReal_Minus1 );
    result.m_equation.setComponent<3>( distance );
    return result;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
