// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Math/Vector/hkIntVector.h>



void hkIntSpaceUtil::transformPositionIntoInt16Space( hkVector4Parameter vecWorldSpace, hkVector4& vecIntSpaceOut ) const
{
    hkVector4 v;
    v.setAdd( m_bitOffset16, vecWorldSpace );
    v.mul( m_bitScale16 );
    vecIntSpaceOut = v;
}

void hkIntSpaceUtil::transformPositionToWorldSpace( hkVector4Parameter vecIntSpace, hkVector4& vecWorldSpaceOut ) const
{
    hkVector4 v;
    v.setMul(vecIntSpace, m_bitScale16Inv);
    v.sub( m_bitOffset16 );
    vecWorldSpaceOut = v;
}

void hkIntSpaceUtil::transformDirectionIntoInt16Space( hkVector4Parameter vecWorldSpace, hkVector4& vecIntSpaceOut ) const
{
    vecIntSpaceOut.setMul( m_bitScale16, vecWorldSpace );
}

void hkIntSpaceUtil::convertAabb(const hkAabb& aabbF, hkAabb16& aabbOut)const
{
#if !defined(HK_ALIGN_RELAX_CHECKS)
    HK_ASSERT( 0xf03ddfe5, 0 == (0xf & hkUlong(&aabbOut)), "Your output aabb is not aligned. Note: you need to align it by hand as hkAabb16 has no alignment declaration.");
#endif

    hkVector4 mi;  mi.setAdd( m_bitOffset16, aabbF.m_min );
    hkVector4 ma;  ma.setAdd( m_bitOffset16, aabbF.m_max );

    mi.mul( m_bitScale16 );
    ma.mul( m_bitScale16 );

    hkVector4 minVal; minVal.setZero();
    hkVector4 maxVal; maxVal.m_quad = s_aabb16Max;

    mi.setMax( minVal, mi );
    ma.setMax( minVal, ma );
    mi.setMin( maxVal, mi );
    ma.setMin( maxVal, ma );

    hkIntVector imi; imi.setConvertF32toS32( mi );
    hkIntVector ima; ima.setConvertF32toS32( ma );

    ((hkIntVector&)aabbOut).setConvertU32ToU16( imi, ima );
}


void hkIntSpaceUtil::restoreAabb(const hkAabb16& aabbI, hkAabb& aabbOut)const
{
    HK_ASSERT( 0xf03dfdfe, (hkUlong(&aabbI)&0xf) == 0, "Your input data is not aligned");
    hkIntVector iZero; iZero.setZero();
    hkIntVector intAabb; intAabb.load<4>( (const hkUint32*)&aabbI);

    hkIntVector iMi; iMi.setCombineHead16To32( iZero, intAabb );
    hkIntVector iMa; iMa.setCombineTail16To32( iZero, intAabb );

    iMa.setAddU32(iMa, hkIntVector::getConstant<HK_QUADINT_1>());

    hkVector4 mi; iMi.convertS32ToF32( mi );
    hkVector4 ma; iMa.convertS32ToF32( ma );

    mi.mul( m_bitScale16Inv );
    ma.mul( m_bitScale16Inv );
    mi.sub( m_bitOffset16 );
    ma.sub( m_bitOffset16 );

    aabbOut.m_min = mi;
    aabbOut.m_max = ma;

}

void hkIntSpaceUtil::castAabb16ToAabbFNoScale(const hkAabb16& aabbI, hkAabb& aabbOut)
{
    HK_ASSERT( 0xf03dfdfe, (hkUlong(&aabbI)&0xf) == 0, "Your input data is not aligned");
    hkIntVector iZero; iZero.setZero();
    hkIntVector intAabb; intAabb.load<4>( (const hkUint32*)&aabbI);

    hkIntVector iMi; iMi.setCombineHead16To32( iZero, intAabb );
    hkIntVector iMa; iMa.setCombineTail16To32( iZero, intAabb );

    iMa.setAddU32(iMa, hkIntVector::getConstant<HK_QUADINT_1>());
    hkVector4 mi; iMi.convertS32ToF32( mi );
    hkVector4 ma; iMa.convertS32ToF32( ma );

    aabbOut.m_min = mi;
    aabbOut.m_max = ma;
}

HK_INLINE void hkIntSpaceUtil::convert4IntToFloatAabbIntSpaceTransposed(_In_reads_(4) const hkAabb16* aabbI, _Inout_updates_all_(3) hkVector4* HK_RESTRICT minXYZOut, _Inout_updates_all_(3) hkVector4* HK_RESTRICT maxXYZOut)
{
    HK_ASSERT( 0xf03dfdfe, (hkUlong(aabbI)&0xf) == 0, "Your input data is not aligned");
    hkIntVector iZero; iZero.setZero();
    hkIntVector intAabb0; intAabb0.load<4>( (const hkUint32*)&aabbI[0] );
    hkIntVector intAabb1; intAabb1.load<4>( (const hkUint32*)&aabbI[1] );
    hkIntVector intAabb2; intAabb2.load<4>( (const hkUint32*)&aabbI[2] );
    hkIntVector intAabb3; intAabb3.load<4>( (const hkUint32*)&aabbI[3] );

    hkIntVector min_xxyyzz01; min_xxyyzz01.setMergeHead16( intAabb0, intAabb1 );
    hkIntVector min_xxyyzz23; min_xxyyzz23.setMergeHead16( intAabb2, intAabb3 );
    hkIntVector min_xxxxyyyy04; min_xxxxyyyy04.setMergeHead32( min_xxyyzz01, min_xxyyzz23 );
    hkIntVector min_zzzz04; min_zzzz04.setMergeTail32( min_xxyyzz01, min_xxyyzz23 );

    hkIntVector min_x04; min_x04.setCombineHead16To32( iZero, min_xxxxyyyy04 );
    hkIntVector min_y04; min_y04.setCombineTail16To32( iZero, min_xxxxyyyy04 );
    hkIntVector min_z04; min_z04.setCombineHead16To32( iZero, min_zzzz04 );

    min_x04.convertS32ToF32( minXYZOut[0] );
    min_y04.convertS32ToF32( minXYZOut[1] );
    min_z04.convertS32ToF32( minXYZOut[2] );

    hkIntVector max_xxyyzz01; max_xxyyzz01.setMergeTail16( intAabb0, intAabb1 );
    hkIntVector max_xxyyzz23; max_xxyyzz23.setMergeTail16( intAabb2, intAabb3 );
    hkIntVector max_xxxxyyyy04; max_xxxxyyyy04.setMergeHead32( max_xxyyzz01, max_xxyyzz23 );
    hkIntVector max_zzzz04; max_zzzz04.setMergeTail32( max_xxyyzz01, max_xxyyzz23 );

    hkIntVector max_x04; max_x04.setCombineHead16To32( iZero, max_xxxxyyyy04 );
    hkIntVector max_y04; max_y04.setCombineTail16To32( iZero, max_xxxxyyyy04 );
    hkIntVector max_z04; max_z04.setCombineHead16To32( iZero, max_zzzz04 );
    hkIntVector one = hkIntVector::getConstant<HK_QUADINT_1>();
    max_x04.setAddU32(max_x04, one);
    max_y04.setAddU32(max_y04, one);
    max_z04.setAddU32(max_z04, one);

    max_x04.convertS32ToF32( maxXYZOut[0] );
    max_y04.convertS32ToF32( maxXYZOut[1] );
    max_z04.convertS32ToF32( maxXYZOut[2] );
}


HK_INLINE void hkIntSpaceUtil::convertInt16ToWorldSpace( const hkAabb& intSpaceAabb, hkAabb& worldSpaceAabbOut ) const
{
    hkVector4 mi = intSpaceAabb.m_min;
    hkVector4 ma = intSpaceAabb.m_max;

    mi.mul( m_bitScale16Inv );
    ma.mul( m_bitScale16Inv );
    mi.sub( m_bitOffset16 );
    ma.sub( m_bitOffset16 );

    worldSpaceAabbOut.m_min = mi;
    worldSpaceAabbOut.m_max = ma;
}

void hkIntSpaceUtil::convertWorldToInt16Space(const hkAabb& aabbF, hkAabb& aabbOut) const
{
#if !defined(HK_ALIGN_RELAX_CHECKS)
    HK_ASSERT( 0xf03ddfe5, 0 == (0xf & hkUlong(&aabbOut)), "Your output aabb is not aligned. Note: you need to align it by hand as hkAabb16 has no alignment declaration.");
#endif

    hkVector4 mi;  mi.setAdd( m_bitOffset16,  aabbF.m_min );
    hkVector4 ma;  ma.setAdd( m_bitOffset16, aabbF.m_max );

    mi.mul( m_bitScale16 );
    ma.mul( m_bitScale16 );

    aabbOut.m_min = mi;
    aabbOut.m_max = ma;
}

void hkIntSpaceUtil::getBorderAabbShrinked(_Inout_ hkAabb16* HK_RESTRICT aabbOut)
{
    aabbOut->m_min[0] = 1;
    aabbOut->m_min[1] = 1;
    aabbOut->m_min[2] = 1;
    aabbOut->m_max[0] = 0x7ffe;
    aabbOut->m_max[1] = 0x7ffe;
    aabbOut->m_max[2] = 0x7ffe;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
