// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/Aabb16/hkAabb16.h>

/// Converts a float AABB to an hkAabb16.
/// Important: assumes the hkAabb16 is aligned on a 16 byte boundary (not aligned by default)
/// When converting from float to int, we always round down, when converting from int to float we
/// add +1 to the max value.
class hkIntSpaceUtil
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkIntSpaceUtil );

        HK_EXPORT_COMMON void set( const hkAabb& aabb );

        /// Convert a floating point aabb in world space to the integer aabb. Does not preserve the keys
        HK_INLINE   void convertAabb(const hkAabb& aabbF,  hkAabb16& aabbOut) const;

        /// Convert an integer aabb into worldspace
        HK_INLINE   void restoreAabb(const hkAabb16& aabbI, hkAabb& aabbOut) const;

        /// Move a position from worldspace into int space
        HK_INLINE void HK_CALL transformPositionIntoInt16Space( hkVector4Parameter vecWorldSpace, hkVector4& vecIntSpaceOut ) const;

        /// Move a direcion from worldspace into int space
        HK_INLINE void HK_CALL transformDirectionIntoInt16Space( hkVector4Parameter vecWorldSpace, hkVector4& vecIntSpaceOut ) const;

        /// Move a position from int space into worldspace
        HK_INLINE void HK_CALL transformPositionToWorldSpace( hkVector4Parameter vecIntSpace, hkVector4& vecWorldSpaceOut ) const;

        /// Convert float to int, no scaling of offseting.
        /// restoreAabb = convertIntToFloatAabbIntSpace+convertIntToWorldSpace.
        HK_INLINE static void HK_CALL castAabb16ToAabbFNoScale( const hkAabb16& aabbI, hkAabb& aabbOut);

        /// Convert a aabbs, float to int, no scaling of offseting. This outputs 4 aabbs rotated!!!!
        /// restoreAabb = convertIntToFloatAabbIntSpace+convertIntToWorldSpace.
        HK_INLINE static void HK_CALL convert4IntToFloatAabbIntSpaceTransposed(_In_reads_(4)const hkAabb16* aabbI, _Inout_updates_all_(3) hkVector4* minXYZOut, _Inout_updates_all_(3) hkVector4* maxXYZOut);

        /// Convert a float aabb in int space to world space.
        /// restoreAabb = convertIntToFloatAabbIntSpace+convertIntToWorldSpace.
        HK_INLINE void convertInt16ToWorldSpace( const hkAabb& intSpaceAabb, hkAabb& worldSpaceAabbOut ) const;

        /// convert a floating point aabb into compressed integer space (still stored as float)
        HK_INLINE void convertWorldToInt16Space(const hkAabb& aabbF, hkAabb& aabbOut) const;

        /// Get the maximum AABB reduced by a small amount (typically 1) so you can use this AABB to detect if an other AABB left the domain
        static HK_INLINE void HK_CALL getBorderAabbShrinked(_Inout_ hkAabb16* HK_RESTRICT aabbOut );

    public:

        enum { AABB_UINT16_MAX_VALUE = 0x7fff };
        HK_EXPORT_COMMON static const hkQuadReal s_aabb16Max;

        hkVector4 m_bitOffset16;
        hkVector4 m_bitScale16;
        hkVector4 m_bitScale16Inv;
        hkAabb m_aabb;              ///< The original aabb that was set as a base for conversion.
};

#include <Common/Base/Types/Geometry/IntSpaceUtil/hkIntSpaceUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
