// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Aabb16/hkAabb16.h>
#include <Common/Base/Types/Geometry/IntSpaceUtil/hkIntSpaceUtil.h>

const hkQuadReal hkIntSpaceUtil::s_aabb16Max = HK_QUADREAL_CONSTANT(
    hkIntSpaceUtil::AABB_UINT16_MAX_VALUE,
    hkIntSpaceUtil::AABB_UINT16_MAX_VALUE,
    hkIntSpaceUtil::AABB_UINT16_MAX_VALUE,
    hkIntSpaceUtil::AABB_UINT16_MAX_VALUE );


void hkIntSpaceUtil::set( const hkAabb& aabb )
{
    m_aabb = aabb;

    hkVector4 span;
    span.setSub( aabb.m_max, aabb.m_min);
    span.setComponent<3>( hkSimdReal_1 );

    hkVector4 spanInv;
    spanInv.setReciprocal<HK_ACC_FULL, HK_DIV_IGNORE>( span );

    hkSimdReal v; v.setFromFloat( hkFloat32(hkIntSpaceUtil::AABB_UINT16_MAX_VALUE+1) ); // we add+1 to avoid rounding
    m_bitScale16.setMul( v, spanInv );
    m_bitOffset16.setNeg<4>( aabb.m_min );
    m_bitScale16Inv.setReciprocal<HK_ACC_FULL, HK_DIV_IGNORE>( m_bitScale16 );

    m_bitOffset16.zeroComponent<3>();
    m_bitScale16   .zeroComponent<3>();
    m_bitScale16Inv.zeroComponent<3>();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
