// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


HK_INLINE void hkGeometry::getTriangle(int triangleIndex, _Inout_updates_all_(3) hkVector4* HK_RESTRICT vertices) const
{
    HK_ASSERT(0xB9C6C634, triangleIndex >= 0 && triangleIndex < m_triangles.getSize(), "Index out-of-range");
    vertices[0] = m_vertices[m_triangles[triangleIndex].m_a];
    vertices[1] = m_vertices[m_triangles[triangleIndex].m_b];
    vertices[2] = m_vertices[m_triangles[triangleIndex].m_c];
}

HK_INLINE hkResult hkGeometry::appendGeometry(const hkGeometry& geometry, const hkTransform& transform)
{
    hkMatrix4 transformMatrix;
    transformMatrix.set(transform);
    return appendGeometry(geometry, &transformMatrix);
}

HK_INLINE hkResult hkGeometry::appendGeometry(const hkGeometry& geometry, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    return appendGeometry(geometry, nullptr, heartbeat);
}

HK_INLINE hkResult hkGeometry::appendGeometry(const hkGeometry& geometry, const hkTransform& transform, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    hkMatrix4 transformMatrix;
    transformMatrix.set(transform);
    return appendGeometry(geometry, &transformMatrix, heartbeat);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
