// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

bool hkFrustum::containsOrIntersects( const hkSphere& sphere ) const
{
    return containsOrIntersects( sphere.getPositionAndRadius() );
}

bool hkFrustum::containsOrIntersects( hkVector4Parameter spherePositionAndRadius ) const
{
    // Calculate the minimum distance of the given sphere's center to all frustum planes.
    hkSimdReal xSphere = spherePositionAndRadius.getComponent<0>();
    hkSimdReal ySphere = spherePositionAndRadius.getComponent<1>();
    hkSimdReal zSphere = spherePositionAndRadius.getComponent<2>();
    hkVector4 radius;
    radius.setAll( spherePositionAndRadius.getComponent<3>() );

    hkVector4 xPlanes0 = m_planes[0].m_equation;
    hkVector4 yPlanes0 = m_planes[1].m_equation;
    hkVector4 zPlanes0 = m_planes[2].m_equation;
    hkVector4 dPlanes0 = m_planes[3].m_equation;

    HK_TRANSPOSE4( xPlanes0, yPlanes0, zPlanes0, dPlanes0 );
    hkVector4 minDist0;
    minDist0.setAddMul( dPlanes0, xPlanes0, xSphere );
    minDist0.addMul( yPlanes0, ySphere );
    minDist0.addMul( zPlanes0, zSphere );

    hkVector4 xPlanes1 = m_planes[4].m_equation;
    hkVector4 yPlanes1 = m_planes[5].m_equation;
    hkVector4 zPlanes1 = m_planes[5].m_equation;
    hkVector4 dPlanes1 = m_planes[5].m_equation;

    HK_TRANSPOSE4( xPlanes1, yPlanes1, zPlanes1, dPlanes1 );
    hkVector4 minDist1;
    minDist1.setAddMul( dPlanes1, xPlanes1, xSphere );
    minDist1.addMul( yPlanes1, ySphere );
    minDist1.addMul( zPlanes1, zSphere );

    hkVector4 minDist;
    minDist.setMin( minDist0, minDist1 );

    // Add the sphere radius to cater for the sphere's extents.
    minDist.add( radius );

    // If the distance is still less than zero, the sphere is completely "outside" of at least one plane.
    return minDist.lessZero().anyIsSet() ? false : true;
}

bool hkFrustum::containsOrIntersects(const hkAabb& aabb) const
{
    hkVector4 center2, extents;
    aabb.getCenter2(center2);
    aabb.getExtents(extents);

    // We're working with center and extents scaled by two - but the plane equation still works out
    // correctly since we set W = 2 here.
    center2.setComponent<3>(hkSimdReal_2);
    extents.zeroComponent<3>();

#if defined(HK_SSE_VERSION) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && defined(HK_REAL_IS_FLOAT)
    hkVector4 minusZero;
    minusZero.setAll(-0.0f);
#endif

    for (hkUint32 plane = 0; plane < ENUM_COUNT; ++plane)
    {
        hkVector4 equation = m_planes[plane].m_equation;

        // Change signs of extents to match signs of plane normal
        hkVector4 maxExtent;
#if defined(HK_SSE_VERSION) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && defined(HK_REAL_IS_FLOAT) && defined(HK_ARCH_INTEL)
        // Specialized for SSE - this is faster than setFlipSign for multiple calls since we can preload the constant -0.0f
        maxExtent.m_quad = _mm_xor_ps(extents.m_quad, _mm_and_ps(minusZero.m_quad, equation.m_quad));
#else
        maxExtent.setFlipSign(extents, equation);
#endif

        // Compute AABB corner which is the furthest along the plane normal
        hkVector4 offset;
        offset.setAdd(center2, maxExtent);

        if (equation.dot<4>(offset).isLessZero())
        {
            // Outside
            return false;
        }
    }

    // Inside or intersect
    return true;
}

//
//  Gets / Sets the i-th plane

const hkPlane& hkFrustum::getPlane(Planes plane) const  {   return m_planes[plane]; }
hkPlane& hkFrustum::accessPlane(Planes plane)           {   return m_planes[plane]; }

template <hkFrustum::Planes plane> const hkPlane& hkFrustum::getPlane() const   {   return m_planes[plane]; }
template <hkFrustum::Planes plane> hkPlane& hkFrustum::accessPlane()            {   return m_planes[plane]; }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
