// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/Plane/hkPlane.h>
#include <Common/Base/Types/Geometry/Sphere/hkSphere.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Common/Base/Math/Matrix/hkMatrix4CameraUtil.h>

/// Stores a frustum
struct HK_EXPORT_COMMON hkFrustum
{
    public:

        HK_DECLARE_CLASS(hkFrustum, New, Reflect, Pod);

        /// The frustum's planes
        enum Planes
        {
            NEAR_PLANE      = 0,
            LEFT_PLANE      = 1,
            RIGHT_PLANE     = 2,
            FAR_PLANE       = 3,
            BOTTOM_PLANE    = 4,
            TOP_PLANE       = 5,

            ENUM_COUNT      = 6,
        };

        /// The frustum's points
        enum Points
        {
            NEAR_TOP_LEFT_POINT     = (NEAR_PLANE << 8) | (TOP_PLANE << 4)      | LEFT_PLANE,
            NEAR_TOP_RIGHT_POINT    = (NEAR_PLANE << 8) | (TOP_PLANE << 4)      | RIGHT_PLANE,
            NEAR_BOTTOM_LEFT_POINT  = (NEAR_PLANE << 8) | (BOTTOM_PLANE << 4)   | LEFT_PLANE,
            NEAR_BOTTOM_RIGHT_POINT = (NEAR_PLANE << 8) | (BOTTOM_PLANE << 4)   | RIGHT_PLANE,
            FAR_TOP_LEFT_POINT      = (FAR_PLANE << 8)  | (TOP_PLANE << 4)      | LEFT_PLANE,
            FAR_TOP_RIGHT_POINT     = (FAR_PLANE << 8)  | (TOP_PLANE << 4)      | RIGHT_PLANE,
            FAR_BOTTOM_LEFT_POINT   = (FAR_PLANE << 8)  | (BOTTOM_PLANE << 4)   | LEFT_PLANE,
            FAR_BOTTOM_RIGHT_POINT  = (FAR_PLANE << 8)  | (BOTTOM_PLANE << 4)   | RIGHT_PLANE,

            NUM_POINTS = 8,
        };

    public:

        // Constructor
        hkFrustum();

        void setFromViewProjection( const hkMatrix4& viewProjection, hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum depthRange );

        HK_INLINE bool containsOrIntersects( const hkAabb& aabb ) const;
        HK_INLINE bool containsOrIntersects( const hkSphere& sphere ) const;
        HK_INLINE bool containsOrIntersects( hkVector4Parameter spherePositionAndRadius ) const;
        bool contains( hkVector4Parameter point ) const;

        /// Gets / Sets the given plane
        HK_INLINE const hkPlane& getPlane(Planes plane) const;
        HK_INLINE hkPlane& accessPlane(Planes plane);

        /// Gets / Sets the given plane
        template <Planes plane> HK_INLINE const hkPlane& getPlane() const;
        template <Planes plane> HK_INLINE hkPlane& accessPlane();

        /// Returns the horizontal FOV angle (in radians)
        hkReal computeHorizontalFov() const;

        /// Returns the vertical FOV angle (in radians)
        hkReal computeVerticalFov() const;

        /// Computes the axis of the frustum
        void computeAxis(hkVector4& axisOut) const;

        /// Computes a point of the frustum
        void computePoint(Points pointIn, hkVector4& pointOut) const;

        /// Calculate 8 intersection points for the frustum's planes:
        /// Near/Left/Top, Near/Left/Bottom, Near/Right/Bottom, Near/Right/Top,
        /// Far/Left/Top, Far/Left/Bottom, Far/Right/Bottom, Far/Right/Top
        void calculatePlaneIntersectionPoints(hkVector4 (&intersectionPoints)[NUM_POINTS]) const;

        /// Returns the geometry of the frustum
        void computeGeometry(hkGeometry& geomOut) const;

  protected:

        /// The frustum's planes
        hkPlane m_planes[ENUM_COUNT];
};

#include <Common/Base/Types/Geometry/Frustum/hkFrustum.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
