// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE void hkConnectivity::getTriangleLinks( int triangleIndex, int* linksOut, int unboundTriangleIndexValue ) const
{
    const Triangle& t = getTriangle( triangleIndex );
    linksOut[ 0 ] = t.m_links[ 0 ].isValid() ? t.m_links[ 0 ].triangle() : unboundTriangleIndexValue;
    linksOut[ 1 ] = t.m_links[ 1 ].isValid() ? t.m_links[ 1 ].triangle() : unboundTriangleIndexValue;
    linksOut[ 2 ] = t.m_links[ 2 ].isValid() ? t.m_links[ 2 ].triangle() : unboundTriangleIndexValue;
}

HK_INLINE hkVector4 hkConnectivity::computeVertexAngleWeightedNormal( const hkGeometry& geometry, int vertexIndex ) const
{
    const hkVector4 origin = geometry.m_vertices[ vertexIndex ];
    const VertexRing ring = getVertexRing( vertexIndex );
    hkVector4 normal; normal.setZero();
    for ( Edge edge : ring )
    {
        int indices[ 3 ]; getVertexIndices( geometry, edge, indices );

        hkVector4 v0 = geometry.m_vertices[ indices[ 1 ] ] - origin;
        hkVector4 v1 = geometry.m_vertices[ indices[ 2 ] ] - origin;
        hkVector4 n; n.setCross( v0, v1 ); n.normalize<3, HK_ACC_FULL, HK_SQRT_SET_ZERO>();

        v0.normalize<3, HK_ACC_FULL, HK_SQRT_SET_ZERO>();
        v1.normalize<3, HK_ACC_FULL, HK_SQRT_SET_ZERO>();

        hkSimdReal cosAngle; cosAngle.setClamped( v0.dot<3>( v1 ), hkSimdReal_Minus1, hkSimdReal_1 );
        hkSimdReal angle; angle.setFromFloat( hkMath::acos( cosAngle.getReal() ) );

        normal.addMul( n, angle );
    }

    normal.normalize<3, HK_ACC_FULL, HK_SQRT_SET_ZERO>();

    return normal;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
