// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename Storage> hkBox<Storage>::hkBox()
{
}

template<typename Storage> hkBox<Storage>::hkBox(Storage x, Storage y, Storage z, Storage width, Storage height, Storage depth)
    : m_x(x), m_y(y), m_z(z), m_width(width), m_height(height), m_depth(depth)
{
}

template<typename Storage> Storage hkBox<Storage>::getX() const
{
    return m_x;
}

template<typename Storage> Storage hkBox<Storage>::getY() const
{
    return m_y;
}

template<typename Storage> Storage hkBox<Storage>::getZ() const
{
    return m_z;
}

template<typename Storage> Storage hkBox<Storage>::getWidth() const
{
    return m_width;
}

template<typename Storage> Storage hkBox<Storage>::getHeight() const
{
    return m_height;
}

template<typename Storage> Storage hkBox<Storage>::getDepth() const
{
    return m_depth;
}

template<typename Storage> void hkBox<Storage>::getPosition(Storage& x, Storage& y, Storage& z) const
{
    x = m_x;
    y = m_y;
    z = m_z;
}

template<typename Storage> void hkBox<Storage>::getSize(Storage& width, Storage& height, Storage& depth) const
{
    width = m_width;
    height = m_height;
    depth = m_depth;
}

// Sets the position of the rectangle
template<typename Storage> void hkBox<Storage>::setPosition(const Storage x, const Storage y, const Storage z)
{
    m_x = x;
    m_y = y;
    m_z = z;
}

// Sets the size of the rectangle
template<typename Storage> void hkBox<Storage>::setSize(const Storage width, const Storage height, const Storage depth)
{
    m_width = width;
    m_height = height;
    m_depth = depth;
}

// Returns true if the rectangle has a non zero area
template<typename Storage> bool hkBox<Storage>::hasNonZeroVolume() const
{
    return (m_width > 0) && (m_height > 0) && (m_depth > 0);
}

template<typename Storage> bool hkBox<Storage>::hasZeroVolume() const
{
    return (m_width == 0) || (m_height == 0) || (m_depth == 0);
}

template<typename Storage> bool hkBox<Storage>::operator == (const hkBox<Storage>& other) const
{
    return hkPoint3d<Storage>(m_x, m_y, m_z) == hkPoint3d<Storage>(other.m_x, other.m_y, other.m_z);
}

template<typename Storage> bool hkBox<Storage>::operator != (const hkBox<Storage>& other) const
{
    return hkPoint3d<Storage>(m_x, m_y, m_z) != hkPoint3d<Storage>(other.m_x, other.m_y, other.m_z);
}

template<typename Storage> bool hkBox<Storage>::isAtOrigin() const
{
    return hkPoint3d<Storage>(m_x, m_y, m_z).isAtOrigin();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
