// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Geometry/Point/hkPoint.h>

/// A box defined by a position and size.
template<typename Storage> class hkBox
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkBox);
        HK_DECLARE_REFLECTION();

            /// Creates an uninitialized box.
        inline hkBox();

            /// Creates an arbitrary box with given position and size.
        inline hkBox(Storage x, Storage y, Storage z, Storage width, Storage height, Storage depth);

            /// This function returns the x position of the box.
        inline Storage getX() const;

            /// This function returns the y position of the box.
        inline Storage getY() const;

            /// This function returns the z position of the box.
        inline Storage getZ() const;

            /// Stores the position of the box in the given parameters
        inline void getPosition(Storage& x, Storage& y, Storage& z) const;

            /// Stores the size (width, height, and depth) of the box in the given parameters
        inline void getSize(Storage& width, Storage& height, Storage& depth) const;

            /// Sets the position of the box
        inline void setPosition(const Storage x, const Storage y, const Storage z);

            /// Sets the size of the box
        inline void setSize(const Storage width, const Storage height, const Storage depth);

            /// Returns true if the box has a non-zero volume
        inline bool hasNonZeroVolume() const;

            /// Returns true if the box has a zero volume
        inline bool hasZeroVolume() const;

            /// This function returns the width of the box.
        inline Storage getWidth() const;

            /// This function returns the height of the box.
        inline Storage getHeight() const;

            /// This function returns the depth of the box.
        inline Storage getDepth() const;

            /// Does a component wise comparison with another box
        inline bool operator == (const hkBox& other) const;

            /// Does a component wise comparison with another box
        inline bool operator != (const hkBox& other) const;

            /// Returns true if the position (x, y, z) is at (0, 0, 0), false otherwise
        inline bool isAtOrigin() const;

    protected:

        Storage m_x;
        Storage m_y;
        Storage m_z;

        Storage m_width;
        Storage m_height;
        Storage m_depth;
};

#include <Common/Base/Types/Geometry/Box/hkBox.inl>
#include <Common/Base/_Auto/TemplateTypes/hkBox_Types.inl>

typedef hkBox<hkInt16> hkBox16;
typedef hkBox<hkInt32> hkBox32;
typedef hkBox<hkReal> hkBoxR;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
