// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE void hkAabb24_16_24_Codec::packAabb(const hkAabb& aabb, _Inout_ hkAabb24_16_24* HK_RESTRICT aabbOut) const
{
    HK_ASSERT( 0xf03ddfe5, 0 == (0xf & hkUlong(aabbOut)), "Your output aabb is not aligned.");

    hkVector4 mi;  mi.setAdd( m_bitOffset24,  aabb.m_min );
    hkVector4 ma;  ma.setAdd( m_bitOffset24, aabb.m_max );
    mi.mul( m_bitScale24 );
    ma.mul( m_bitScale24 );
    HK_ON_DEBUG(hkBool32 isMax = 1);
#if !defined(HK_INT_VECTOR_NATIVE_PERMUTE8)
    hkVector4 minVal; minVal.setZero();
    mi.setMax(minVal, mi);
    ma.setMax(minVal, ma);
    mi.setMin(m_aabb24_16_24_Max, mi);
    ma.setMin(m_aabb24_16_24_Max, ma);

#if defined(HK_DEBUG)
    isMax  = mi.equal(minVal).getMask<hkVector4ComparisonMask::MASK_XYZ>();
    isMax |= ma.equal(minVal).getMask<hkVector4ComparisonMask::MASK_XYZ>();
    isMax |= mi.equal(m_aabb24_16_24_Max).getMask<hkVector4ComparisonMask::MASK_XYZ>();
    isMax |= ma.equal(m_aabb24_16_24_Max).getMask<hkVector4ComparisonMask::MASK_XYZ>();
#endif

    hkIntVector imi; imi.setConvertF32toS32( mi );
    hkIntVector ima; ima.setConvertF32toS32( ma );

    {
        hkUint32 x = (hkUint32)imi.getComponent<0>();
        hkUint32 y = (hkUint32)imi.getComponent( 1+m_yzReversed );
        hkUint32 z = (hkUint32)imi.getComponent( 2-m_yzReversed );
        aabbOut->m_min.m_comp.m_xxxhy = (x<<8)  |  (y>>8);
        aabbOut->m_min.m_comp.m_lyzzz = (y<<24) |  (z);
    }
    {
        int x = ima.getComponent<0>();
        int y = ima.getComponent( 1+m_yzReversed );
        int z = ima.getComponent( 2-m_yzReversed );
        aabbOut->m_max.m_comp.m_xxxhy = (x<<8)  |  (y>>8);
        aabbOut->m_max.m_comp.m_lyzzz = (y<<24) |  (z);
    }
#else
    hkIntVector imi; imi.setConvertF32toS32( mi );
    hkIntVector ima; ima.setConvertF32toS32( ma );

    // do the min/max using integer since faster than using floating point
    hkIntVector minVal; minVal.setZero();
    imi.setMaxS32( minVal, imi );
    ima.setMaxS32( minVal, ima );
    imi.setMinS32( m_aabb24_16_24_iMax, imi );
    ima.setMinS32( m_aabb24_16_24_iMax, ima );

    imi.setPermuteU8(imi, m_packPermuteMask );
    ima.setPermuteU8(ima, m_packPermuteMask );
    ((hkIntVector*)aabbOut)->setSelect<hkVector4ComparisonMask::MASK_XY>( imi, ima );

#endif  //HK_USING_GENERIC_INT_VECTOR_IMPLEMENTATION
#if 1 && defined(HK_DEBUG)
    hkAabb check; restoreAabb(*aabbOut, check);
    HK_ASSERT_NO_MSG(0xf04fcffe, isMax || check.contains(aabb));
#endif
}

HK_INLINE void hkAabb24_16_24_Codec::unpackAabb24Unscaled( const hkAabb24_16_24& aabb, _Inout_ hkAabb* HK_RESTRICT aabbFOut ) const
{
#if defined(HK_USING_GENERIC_INT_VECTOR_IMPLEMENTATION)
    aabbFOut->m_min(0) = hkReal(hkInt32(aabb.m_min.m_comp.m_xxxhy>>8) + m_intToFloatMinOffset.getComponent<0>());
    aabbFOut->m_max(0) = hkReal(hkInt32(aabb.m_max.m_comp.m_xxxhy>>8) + m_intToFloatMaxOffset.getComponent<0>());

    aabbFOut->m_min(1+m_yzReversed) = hkReal(*(const hkUint16*)&aabb.m_min.m_u8[3] + m_intToFloatMinOffset.getComponent<1>());
    aabbFOut->m_max(1+m_yzReversed) = hkReal(*(const hkUint16*)&aabb.m_max.m_u8[3] + m_intToFloatMaxOffset.getComponent<1>());

    aabbFOut->m_min(2-m_yzReversed) = hkReal(hkInt32(aabb.m_min.m_comp.m_lyzzz & 0xffffff) + m_intToFloatMinOffset.getComponent<2>());
    aabbFOut->m_max(2-m_yzReversed) = hkReal(hkInt32(aabb.m_max.m_comp.m_lyzzz & 0xffffff) + m_intToFloatMaxOffset.getComponent<2>());
    aabbFOut->m_min(3) = hkReal(0);
    aabbFOut->m_max(3) = hkReal(0);
#elif defined(HK_INT_VECTOR_NATIVE_PERMUTE8)
#   if HK_ENDIAN_BIG
    hkIntVector zero; zero.setZero();
    hkIntVector imi; imi.setPermuteU8( (const hkIntVector&)aabb, zero, m_permuteMaskMin );
    hkIntVector ima; ima.setPermuteU8( (const hkIntVector&)aabb, zero, m_permuteMaskMax );
#   else
    // intel, does not have a full native setPermuteU8 with 2 input vectors, use single version with and
    hkIntVector imi; imi.setPermuteU8( (const hkIntVector&)aabb, m_permuteMaskMin );
    hkIntVector ima; ima.setPermuteU8( (const hkIntVector&)aabb, m_permuteMaskMax );
    imi.setAnd( imi, m_unpackMask );
    ima.setAnd( ima, m_unpackMask );
#   endif
    imi.setAddU32(imi, m_intToFloatMinOffset);
    ima.setAddU32(ima, m_intToFloatMaxOffset);

    imi.convertS32ToF32(aabbFOut->m_min);
    ima.convertS32ToF32(aabbFOut->m_max);
#else
    extern HK_EXPORT_COMMON const HK_ALIGN16( hkUint32 hkAabb24_16_24_Codec_unpackMaskXCst[4] );
    extern HK_EXPORT_COMMON const HK_ALIGN16( hkUint32 hkAabb24_16_24_Codec_unpackMaskYCst[4] );
    extern HK_EXPORT_COMMON const HK_ALIGN16( hkUint32 hkAabb24_16_24_Codec_unpackMaskZCst[4] );
    hkIntVector m_unpackMaskX; m_unpackMaskX.load<4>(hkAabb24_16_24_Codec_unpackMaskXCst);
    hkIntVector m_unpackMaskY; m_unpackMaskY.load<4>(hkAabb24_16_24_Codec_unpackMaskYCst);
    hkIntVector m_unpackMaskZ; m_unpackMaskZ.load<4>(hkAabb24_16_24_Codec_unpackMaskZCst);
    {
        hkIntVector a; a.load<4>( (hkUint32*)(&aabb) );
#if HK_ENDIAN_LITTLE
        hkIntVector x; x.setShiftLeft128<5>( a );
        hkIntVector y; y.setShiftLeft128<3>( a );
        hkIntVector z; z.setPermutation<hkVectorPermutation::XXZZ>(a); // now we have minz minz maxz maxz
#else
        hkIntVector x; x.setPermutation<hkVectorPermutation::YXWZ>(a);
        hkIntVector y; y.setShiftRight128<3>( a );
        hkIntVector z; z.setShiftRight128<5>( a );  // now we have - minz - maxz
#endif

        y.setAnd( y, m_unpackMaskY );   // now we have miny - maxy -
        z.setAnd( z, m_unpackMaskZ );   // now we have - minz - maxz
        x.setAnd( x, m_unpackMaskX );   // now we have minx - maxx -

        x.setOr( x, z );                                // now we have minx minz maxx maxz
        hkIntVector imi; imi.setMergeHead32( x,y );
        hkIntVector ima; ima.setMergeTail32( x,y );
        if ( m_yzReversed )
        {
            imi.setPermutation<hkVectorPermutation::XZYW>(imi);
            ima.setPermutation<hkVectorPermutation::XZYW>(ima);
        }
        imi.setAddU32(imi, m_intToFloatMinOffset);
        ima.setAddU32(ima, m_intToFloatMaxOffset);

        imi.convertS32ToF32(aabbFOut->m_min);
        ima.convertS32ToF32(aabbFOut->m_max);
    }
#endif
}

HK_INLINE void hkAabb24_16_24_Codec::getBorderAabbShrinked(_Inout_ hkAabb24_16_24* HK_RESTRICT aabbOut )
{
    aabbOut->m_min.m_xxxyyzzz = 0x0000010001000001LL;
    aabbOut->m_max.m_xxxyyzzz = 0x7ffef07ffe7ffef0LL;
}

HK_INLINE void hkAabb24_16_24_Codec::transformInt24ToWorldSpace( const hkAabb& intSpaceAabb, hkAabb& worldSpaceAabbOut ) const
{
    hkVector4 mi = intSpaceAabb.m_min;
    hkVector4 ma = intSpaceAabb.m_max;

    mi.mul( m_bitScale24Inv );
    ma.mul( m_bitScale24Inv );
    mi.sub( m_bitOffset24 );
    ma.sub( m_bitOffset24 );

    worldSpaceAabbOut.m_min = mi;
    worldSpaceAabbOut.m_max = ma;
}


HK_INLINE void hkAabb24_16_24_Codec::restoreAabb( const hkAabb24_16_24& aabb, hkAabb& aabbFOut ) const
{
    hkAabb unscaled;    unpackAabb24Unscaled( aabb, &unscaled );
    transformInt24ToWorldSpace( unscaled, aabbFOut );
}

template<>
HK_INLINE void hkAabb16::set2( const hkAabb24_16_24& other, const hkAabb24_16_24_Codec& codec )
{
    hkAabb16* HK_RESTRICT d = this;
    int r = codec.m_yzReversed;
    d->m_min[0] = other.m_min.m_comp.m_xxxhy>>16;
    d->m_max[0] = other.m_max.m_comp.m_xxxhy>>16;
    d->m_min[2-r] = 0xffff & (other.m_min.m_comp.m_lyzzz>>8);
    d->m_max[2-r] = 0xffff & (other.m_max.m_comp.m_lyzzz>>8);
    d->m_min[1+r] = *(hkUint16*)&other.m_min.m_u8[3];   // aligned axes, might crash
    d->m_max[1+r] = *(hkUint16*)&other.m_max.m_u8[3];
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
