// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE


#pragma once

#include <Common/Base/Types/Geometry/Aabb24_16_24/hkAabb24_16_24.h>
#include <Common/Base/Types/Geometry/IntSpaceUtil/hkIntSpaceUtil.h>

/// This class converts a float position into integer coordinates inside a predefined max AABB domain.
/// Notes:
///   - this class uses 24 bit for x, 16 and 24 bit for y and z.
///   - this class optionally swaps y and z so that either y or z can get the reduced 16 bit precision (typically up).
///   - swapping of y and z is done in the last moment just before storing the data into the hkAabb24_16_24,
///     this means all other hkVector4 values are not swapped.
class hkAabb24_16_24_Codec : public hkIntSpaceUtil
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkAabb24_16_24_Codec );

        HK_EXPORT_COMMON void set( const hkAabb& aabb );

        HK_INLINE void packAabb( const hkAabb& aabb, _Inout_ hkAabb24_16_24* HK_RESTRICT aabbOut ) const;

        HK_INLINE void convertAabb(const hkAabb& aabbF,  hkAabb24_16_24& aabbOut) const {   packAabb(aabbF, &aabbOut ); }

        HK_INLINE void unpackAabb24Unscaled( const hkAabb24_16_24& aabb, _Inout_ hkAabb* HK_RESTRICT aabbOut) const;

        /// restores the aabb, is conservative that the output aabb will contain the initial aabb
        HK_INLINE void restoreAabb( const hkAabb24_16_24& aabb, hkAabb& aabbFOut ) const;

        /// Convert a float aabb in int space to world space.
        /// restoreAabb = convertIntToFloatAabbIntSpace+convertIntToWorldSpace.
        HK_INLINE void transformInt24ToWorldSpace( const hkAabb& intSpaceAabb, hkAabb& worldSpaceAabbOut ) const;

        /// Get the maximum AABB reduced by a small amount (typically 1) so you can use this AABB to detect if an other AABB left the domain
        static HK_INLINE void HK_CALL getBorderAabbShrinked(_Inout_ hkAabb24_16_24* HK_RESTRICT aabbOut );

    public:
        hkVector4 m_bitOffset24;        ///< the origin of the domain.
        hkVector4 m_bitScale24;         ///< multiply by this value to scale from float to int space
        hkVector4 m_bitScale24Inv;

        int                 m_yzReversed;
        hkIntVector         m_packPermuteMask;  ///< the permute mask to pack min or max, this packs x,y,z into xy = zw
        hkIntVector         m_permuteMaskMin;   ///< the permute mask to unpack min, note that this is platform dependent.
        hkIntVector         m_permuteMaskMax;
    #if HK_ENDIAN_LITTLE
        hkIntVector         m_unpackMask;       ///< Needed by intel for fast unpacking
    #endif
        hkVector4Comparison m_yzIsReversed;
        hkVector4           m_aabb24_16_24_Max;     ///< the max in float space
        hkIntVector         m_aabb24_16_24_iMax;    ///< the max in integer space store in integer
        hkIntVector         m_intToFloatMaxOffset;  ///< an extra rounding to ensure we are not shrinking an aabb
        hkIntVector         m_intToFloatMinOffset;  ///< an extra rounding to ensure we are not shrinking an aabb
};


#include <Common/Base/Types/Geometry/Aabb24_16_24/hkAabb24_16_24_Codec.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
