// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Aabb24_16_24/hkAabb24_16_24_Codec.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

// Used in .inl file
extern HK_EXPORT_COMMON const HK_ALIGN16( hkUint32 hkAabb24_16_24_Codec_unpackMaskXCst[4] ) = { 0xffffff, 0, 0xffffff, 0 };
extern HK_EXPORT_COMMON const HK_ALIGN16( hkUint32 hkAabb24_16_24_Codec_unpackMaskYCst[4] ) = { 0xffff, 0, 0xffff, 0 };
extern HK_EXPORT_COMMON const HK_ALIGN16( hkUint32 hkAabb24_16_24_Codec_unpackMaskZCst[4] ) = { 0, 0xffffff, 0, 0xffffff };

namespace
{
#if HK_ENDIAN_LITTLE    // intel
    static const HK_ALIGN16( hkUint8 s_maskMinY[16] ) = { 0x05, 0x06, 0x07, 0x00,  0x03, 0x04, 0x00, 0x00,  0x00, 0x01, 0x02, 0x00,  0x00, 0x00, 0x00, 0x00 };
    static const HK_ALIGN16( hkUint8 s_maskMaxY[16] ) = { 0x0d, 0x0e, 0x0f, 0x00,  0x0b, 0x0c, 0x00, 0x00,  0x08, 0x09, 0x0a, 0x0f,  0x00, 0x00, 0x00, 0x00 };
    static const HK_ALIGN16( hkUint8 s_maskMinZ[16] ) = { 0x05, 0x06, 0x07, 0x00,  0x00, 0x01, 0x02, 0x00,  0x03, 0x04, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00 };
    static const HK_ALIGN16( hkUint8 s_maskMaxZ[16] ) = { 0x0d, 0x0e, 0x0f, 0x00,  0x08, 0x09, 0x0a, 0x0f,  0x0b, 0x0c, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00 };

    static const HK_ALIGN16( hkUint8 s_unpackMaskY[16] ) = { 0xff, 0xff, 0xff, 0x00,  0xff, 0xff, 0x00, 0x00,  0xff, 0xff, 0xff, 0x00,  0x00, 0x00, 0x00, 0x00 };
    static const HK_ALIGN16( hkUint8 s_unpackMaskZ[16] ) = { 0xff, 0xff, 0xff, 0x00,  0xff, 0xff, 0xff, 0x00,  0xff, 0xff, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00 };

    static const HK_ALIGN16( hkUint8 s_packMask[16] ) = { 0x08, 0x09, 0x0a,  0x04, 0x05,  0x00, 0x01, 0x02,   0x08, 0x09, 0x0a,  0x04, 0x05,  0x00, 0x01, 0x02 };
    static const HK_ALIGN16( hkUint8 s_packMaskRev[16] ) = { 0x04, 0x05, 0x06,  0x08, 0x09,  0x00, 0x01, 0x02,   0x04, 0x05, 0x06,  0x08, 0x09,  0x00, 0x01, 0x02 };
#else   // ppc
    static const HK_ALIGN16( hkUint8 s_maskMinY[16] ) = { 0x10, 0x00, 0x01, 0x02,  0x10, 0x10, 0x03, 0x04,  0x10, 0x05, 0x06, 0x07,  0x10, 0x10, 0x10, 0x10 };
    static const HK_ALIGN16( hkUint8 s_maskMaxY[16] ) = { 0x10, 0x08, 0x09, 0x0a,  0x10, 0x10, 0x0b, 0x0c,  0x10, 0x0d, 0x0e, 0x0f,  0x10, 0x10, 0x10, 0x10 };
    static const HK_ALIGN16( hkUint8 s_maskMinZ[16] ) = { 0x10, 0x00, 0x01, 0x02,  0x10, 0x05, 0x06, 0x07,  0x10, 0x10, 0x03, 0x04,  0x10, 0x10, 0x10, 0x10 };
    static const HK_ALIGN16( hkUint8 s_maskMaxZ[16] ) = { 0x10, 0x08, 0x09, 0x0a,  0x10, 0x0d, 0x0e, 0x0f,  0x10, 0x10, 0x0b, 0x0c,  0x10, 0x10, 0x10, 0x10 };

    static const HK_ALIGN16( hkUint8 s_packMask[16] ) = { 0x01, 0x02, 0x03,  0x06, 0x07,  0x09, 0x0a, 0x0b,  0x01, 0x02, 0x03,  0x06, 0x07,  0x09, 0x0a, 0x0b };
    static const HK_ALIGN16( hkUint8 s_packMaskRev[16] ) = { 0x01, 0x02, 0x03,  0x0a, 0x0b,  0x05, 0x06, 0x07,  0x01, 0x02, 0x03,  0x0a, 0x0b,  0x05, 0x06, 0x07 };
#endif
}


void hkAabb24_16_24_Codec::set( const hkAabb& aabb )
{
    hkIntSpaceUtil::set( aabb );

    hkVector4 extent; extent.setSub( aabb.m_max, aabb.m_min );
    hkIntVector asInt; asInt.loadAsFloat32BitRepresentation( extent );
    hkIntVector mantMask; mantMask.setAll( 0x007fffff);
    hkIntVector expMask; expMask.setAll( 0x7f800000);
    hkIntVector expInc; expInc.setAll( 0x00800000);
    mantMask.setAnd( mantMask, asInt );
    bool isPowerOf2 = true;
    if ( !mantMask.equalZeroS32().allAreSet() )
    {
        HK_WARN_ONCE( 0xf0345456, "Your broadphase size should be a power of 2 or your bounding volumes might not fit perfectly");
        isPowerOf2 = false;
    }

    int minComp = extent.getIndexOfMinComponent<3>();

    hkVector4 maxInt;
    if ( minComp == 2 )
    {
        m_yzReversed = 1;
        m_yzIsReversed.set<hkVector4ComparisonMask::MASK_XYZW>();
        m_aabb24_16_24_iMax.set( 0x7fff00LL, 0x7fff00LL, 0x7fffLL, 0);
        m_aabb24_16_24_Max.set( hkReal(0x7fff00LL), hkReal(0x7fff00LL), hkReal(0x7fffLL), 1.0f );
        maxInt.set( hkReal(0x800000LL), hkReal(0x800000LL), hkReal(0x8000LL), 1.0f );
        m_permuteMaskMin = *(hkIntVector*)s_maskMinZ;
        m_permuteMaskMax = *(hkIntVector*)s_maskMaxZ;
        m_packPermuteMask = *(const hkIntVector*) s_packMaskRev;
#if HK_ENDIAN_LITTLE
        m_unpackMask     = *(hkIntVector*)s_unpackMaskZ;
#endif
    }
    else
    {
        minComp = 1;
        m_yzReversed = 0;
        m_aabb24_16_24_iMax.set( 0x7fff00, 0x7fff, 0x7fff00, 0);
        m_aabb24_16_24_Max.set( hkReal(0x7fff00), hkReal(0x7fff), hkReal(0x7fff00), 1.0f );
        maxInt.set( hkReal(0x800000LL), hkReal(0x8000LL), hkReal(0x800000LL), 1.0f );

        m_packPermuteMask = *(const hkIntVector*) s_packMask;

        m_yzIsReversed.set<hkVector4ComparisonMask::MASK_NONE>();
        m_permuteMaskMin = *(hkIntVector*)s_maskMinY;
        m_permuteMaskMax = *(hkIntVector*)s_maskMaxY;
#if HK_ENDIAN_LITTLE
        m_unpackMask     = *(hkIntVector*)s_unpackMaskY;
#endif
    }

    hkVector4 span;     span.setSub( aabb.m_max, aabb.m_min);
    hkVector4 spanInv;  spanInv.setReciprocal<HK_ACC_FULL, HK_DIV_SET_ZERO>(span);

    spanInv.setComponent<3>(hkSimdReal_1);

    m_bitScale24.setMul( maxInt, spanInv );
    m_bitOffset24.setNeg<4>( aabb.m_min );

    m_bitScale24  .zeroComponent<3>();
    m_bitOffset24 .zeroComponent<3>();

    m_bitScale24Inv.setReciprocal<HK_ACC_FULL, HK_DIV_SET_ZERO>( m_bitScale24 );

    int eps = isPowerOf2 ? 0 : 1;
    int eps24 = 1;

    m_intToFloatMaxOffset.setAll( 1 + eps + eps24 );
    m_intToFloatMinOffset.setAll( -eps - eps24);
    m_intToFloatMaxOffset.setComponent(minComp, 1 + eps);
    m_intToFloatMinOffset.setComponent(minComp, -eps24);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
