// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Aabb24_16_24/hkAabb24_16_24.h>
#include <Common/Base/Math/Vector/hkIntVector.h>


#if 0
void hkAabb20::setExtents(_In_reads_(numAabbsIn) const hkAabb20* aabbsIn, int numAabbsIn )
{
#if defined(HK_USING_GENERIC_INT_VECTOR_IMPLEMENTATION)
    {
        hkAabb20 aabbOut;   aabbOut.setEmpty();
        for(int i=0; i<numAabbsIn; i++)
        {
            aabbOut.includeAabb( aabbsIn[i] );
        }
        this[0] = aabbOut;
    }
#else
    hkIntVector vmin; vmin.load<4>( (const hkUint32*)aabbsIn );
    hkIntVector vmax = vmin;
    for (int i = 1; i < numAabbsIn; i++ )
    {
        hkIntVector a; a.load<4>( (const hkUint32*)&aabbsIn[i]  );
        vmin.setMinS16( vmin, a );
        vmax.setMaxS16( vmax, a );
    }
    vmax.store<4>( (hkUint32*)this);
    vmin.store<2>( (hkUint32*)this);
#endif
}


void hkAabb24_16_24::setIntersection( const hkAabb24_16_24& aabb0, const hkAabb24_16_24& aabb1  )
{
#if defined(HK_USING_GENERIC_INT_VECTOR_IMPLEMENTATION)
    {
        m_max[0] = hkMath::min2( aabb0.m_max[0], aabb1.m_max[0] );
        m_max[1] = hkMath::min2( aabb0.m_max[1], aabb1.m_max[1] );
        m_max[2] = hkMath::min2( aabb0.m_max[2], aabb1.m_max[2] );

        m_min[0] = hkMath::max2( aabb0.m_min[0], aabb1.m_min[0] );
        m_min[1] = hkMath::max2( aabb0.m_min[1], aabb1.m_min[1] );
        m_min[2] = hkMath::max2( aabb0.m_min[2], aabb1.m_min[2] );

    }
#else
    hkIntVector vmin; vmin.load<4>( (const hkUint32*)&aabb0 );
    hkIntVector vmax = vmin;
    hkIntVector a; a.load<4>( (const hkUint32*)&aabb1  );
    vmin.setMaxS16( vmin, a );
    vmax.setMinS16( vmax, a );
    vmax.store<4>( (hkUint32*)this);
    vmin.store<2>( (hkUint32*)this);
#endif
}


void hkAabb24_16_24::setExtentsOfCenters(_In_reads_(numAabbsIn) const hkAabb24_16_24* aabbsIn, int numAabbsIn )
{
#if defined(HK_USING_GENERIC_INT_VECTOR_IMPLEMENTATION)
    {
        hkUint32 leafMax2[3], leafMin2[3];
        hkAabb24_16_24 aabbOut; aabbOut.setEmpty();
        for(int ie=0; ie<numAabbs; ie++)
        {
            hkUint32 center2[3];
            aabbsIn[ie].getCenter2( center2 );
            aabbOut.includePoint( leafMax2, leafMin2, center2 );
        }
        this[0] = aabbOut;
    }
#else
    hkIntVector vmin;
    {
        hkIntVector mi; mi.load<4>( (const hkUint32*)&aabbsIn[0]  );
        hkIntVector ma; ma.setPermutation<hkVectorPermutation::ZWWW>(mi);
        hkIntVector center2; center2.setAddSaturateU16( mi, ma );
        vmin.setShiftRight16<1>( center2);
    }
    hkIntVector vmax = vmin;
    for (int i = 1; i < numAabbsIn; i++ )
    {
        hkIntVector mi; mi.load<4>( (const hkUint32*)&aabbsIn[i]  );
        hkIntVector ma; ma.setPermutation<hkVectorPermutation::ZWWW>(mi);
        hkIntVector center2; center2.setAddSaturateU16( mi, ma );
        hkIntVector center; center.setShiftRight16<1>( center2);

        vmin.setMinS16( vmin, center );
        vmax.setMaxS16( vmax, center );
    }
    vmin.store<2>( ((hkUint32*)this) + 0 );
    vmax.store<2>( ((hkUint32*)this) + 2);
#endif
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
