// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


template<>
HK_INLINE void hkAabb16::setKey(hkUint16 key)
{
    m_key = key;
}

HK_INLINE void hkAabb16::getKey(hkUint16& key) const
{
    key = m_key;
}

template<>
HK_INLINE void hkAabb16::setKey(hkUint32 key)
{
    m_key = hkUint16(key & 0xffff);
    m_key1 = hkUint16(key >> 16);
}

HK_INLINE void hkAabb16::getKey(hkUint32& key) const
{
    key = (m_key1<<16) | m_key;
}

void hkAabb16::setEmpty()
{
    m_min[0] = m_min[1] = m_min[2] = 0xffff;
    m_max[0] = m_max[1] = m_max[2] = 0;
    m_key = m_key1 = 0;
}

void hkAabb16::setEndMarker()
{
    m_min[0] = 0xffff;
    m_min[1] = m_min[2] = 0x7fff;
    m_max[0] = m_max[1] = m_max[2] = 0;
}

HK_INLINE bool hkAabb16::isEndMarker() const
{
    return m_min[0] == 0xffff;
}
class hkIntSpaceUtil;

HK_INLINE void hkAabb16::set( const hkAabb16& other )
{
    hkIntVector h;
    h.load<4>( (const hkUint32*)&other);
    h.store<4>( (hkUint32*)this);
}

class hkIntSpaceUtil;

template<>
HK_INLINE void hkAabb16::set2( const hkAabb16& other, const hkIntSpaceUtil& codec )
{
    *this = other;

}
#if defined(HK_PLATFORM_WIN32) && !defined(__HAVOK_PARSER__)
template<typename AABB, typename CODEC>         ///< implement for hkAabb16 and hkAabb24_16_24
HK_INLINE void hkAabb16::set2( const AABB& other, const CODEC& codec )
{
    HK_COMPILE_TIME_ASSERT( 0 == 1 );   // not implemented (only checked on win 32 since other compilers produce a compile error always
}
#endif

bool hkAabb16::isEmpty() const
{
    hkUint16 val0 = (m_min[0]^0xffff) | m_max[0];
    hkUint16 val1 = (m_min[1]^0xffff) | m_max[1];
    hkUint16 val2 = (m_min[2]^0xffff) | m_max[2];
    return 0 == (val0|val1|val2);
}

HK_INLINE hkUint32 hkAabb16::getMinXSortKey() const
{
    return m_min[0];
}

HK_INLINE hkUint32 hkAabb16::getMaxXSortKey() const
{
    return m_max[0];
}


void hkAabb16::getExtent(hkUint32 extent[3]) const
{
    extent[0] = m_max[0] - m_min[0];
    extent[1] = m_max[1] - m_min[1];
    extent[2] = m_max[2] - m_min[2];
}

// hkUint32 hkAabb16::getMajorExtent() const
// {
//  hkUint32 extent[3];
//  getExtent( extent );
//
//  int majorAxis = 0;
//  majorAxis = ( extent[majorAxis] < extent[1] ) ? 1 : majorAxis;
//  majorAxis = ( extent[majorAxis] < extent[2] ) ? 2 : majorAxis;
//
//  return extent[ majorAxis ];
// }

void hkAabb16::getCenter2(hkVector4& c) const
{
    c.set(  hkReal(m_min[0] + (int)m_max[0]),
            hkReal(m_min[1] + (int)m_max[1]),
            hkReal(m_min[2] + (int)m_max[2]), 0.0f);
}

void hkAabb16::getExtents(hkVector4& c) const
{
    c.set(  hkReal(m_max[0] - m_min[0]),
            hkReal(m_max[1] - m_min[1]),
            hkReal(m_max[2] - m_min[2]), 0.0f);
}

hkBool32 hkAabb16::disjoint(const hkAabb16& testAabb) const
{
    union PointerUnion { const hkUint16* s; const hkUint32* i; };

    int z0 = int(m_max[2]) - int(testAabb.m_min[2]);
    int z1 = int(testAabb.m_max[2]) - int(m_min[2]);

    PointerUnion pmin; pmin.s = &m_min[0];
    PointerUnion pmax; pmax.s = &m_max[0];
    hkUint32 minAxy = *pmin.i;
    hkUint32 maxAxy = *pmax.i;

    PointerUnion pBmin; pBmin.s = &testAabb.m_min[0];
    PointerUnion pBmax; pBmax.s = &testAabb.m_max[0];
    hkUint32 minBxy = *pBmin.i;
    hkUint32 maxBxy = *pBmax.i;

    maxAxy -= minBxy;
    maxBxy -= minAxy;
    z0 |= z1;
    maxAxy |= maxBxy;
    maxAxy |= z0;
    return maxAxy & 0x80008000;

    // old overlap test
//  int y0 = int(m_max[1]) - int(testAabb.m_min[1]);
//  int z0 = int(m_max[2]) - int(testAabb.m_min[2]);
//
//  int y1 = int(testAabb.m_max[1]) - int(m_min[1]);
//  int z1 = int(testAabb.m_max[2]) - int(m_min[2]);
//
//  x0 |= y0;
//  x1 |= y1;
//  x0 |= z0;
//  x1 |= z1;
//
//  x0 |= x1;
//
//  hkBool32 ovl = (~x0) & 0x80000000;
//
//  return ovl;
}

hkBool32 hkAabb16::overlaps(const hkAabb16& other) const
{
    hkUint16 x0 = m_max[0] - other.m_min[0];
    hkUint16 y0 = m_max[1] - other.m_min[1];
    hkUint16 z0 = m_max[2] - other.m_min[2];

    hkUint16 x1 = other.m_max[0] - m_min[0];
    hkUint16 y1 = other.m_max[1] - m_min[1];
    hkUint16 z1 = other.m_max[2] - m_min[2];

    x0 |= y0;
    x1 |= y1;
    x0 |= z0;
    x1 |= z1;

    x0 |= x1;

    hkBool32 ovl = (~x0) & 0x8000;

    return ovl;
}

void hkAabb16::includePoint( hkUint32 c[3] )
{
    m_max[0] = hkMath::max2( m_max[0], c[0] );
    m_max[1] = hkMath::max2( m_max[1], c[1] );
    m_max[2] = hkMath::max2( m_max[2], c[2] );

    m_min[0] = hkMath::min2( m_min[0], c[0] );
    m_min[1] = hkMath::min2( m_min[1], c[1] );
    m_min[2] = hkMath::min2( m_min[2], c[2] );
}

void hkAabb16::includeAabb( const hkAabb16& in )
{
    m_max[0] = hkMath::max2( m_max[0], in.m_max[0] );
    m_max[1] = hkMath::max2( m_max[1], in.m_max[1] );
    m_max[2] = hkMath::max2( m_max[2], in.m_max[2] );

    m_min[0] = hkMath::min2( m_min[0], in.m_min[0] );
    m_min[1] = hkMath::min2( m_min[1], in.m_min[1] );
    m_min[2] = hkMath::min2( m_min[2], in.m_min[2] );
}

hkBool32 hkAabb16::contains( const hkAabb16& testAabb ) const
{
    hkUint16 x0 = m_max[0] - testAabb.m_max[0];
    hkUint16 y0 = m_max[1] - testAabb.m_max[1];
    hkUint16 z0 = m_max[2] - testAabb.m_max[2];

    hkUint16 x1 = testAabb.m_min[0] - m_min[0];
    hkUint16 y1 = testAabb.m_min[1] - m_min[1];
    hkUint16 z1 = testAabb.m_min[2] - m_min[2];

    x0 |= y0;
    x1 |= y1;
    x0 |= z0;
    x1 |= z1;

    x0 |= x1;

    hkBool32 ovl = (~x0) & 0x8000;

    return ovl;
}

void hkAabb16::setUnion( const hkAabb16& aabb0, const hkAabb16& aabb1 )
{
    set(aabb0);
    includeAabb(aabb1);
}

bool hkAabb16::isEqual( const hkAabb16& testAabb ) const
{
    hkUint16 x0 = m_max[0] - testAabb.m_max[0];
    hkUint16 y0 = m_max[1] - testAabb.m_max[1];
    hkUint16 z0 = m_max[2] - testAabb.m_max[2];

    hkUint16 x1 = testAabb.m_min[0] - m_min[0];
    hkUint16 y1 = testAabb.m_min[1] - m_min[1];
    hkUint16 z1 = testAabb.m_min[2] - m_min[2];

    x0 |= y0;
    x1 |= y1;
    x0 |= z0;
    x1 |= z1;

    x0 |= x1;

    return x0 == 0;
}

hkBool32 hkAabb16::containsDontTouch( const hkAabb16& testAabb ) const
{
    int x0 = (m_max[0] - testAabb.m_max[0])-1;
    int y0 = (m_max[1] - testAabb.m_max[1])-1;
    int z0 = (m_max[2] - testAabb.m_max[2])-1;

    int x1 = (testAabb.m_min[0] - m_min[0])-1;
    int y1 = (testAabb.m_min[1] - m_min[1])-1;
    int z1 = (testAabb.m_min[2] - m_min[2])-1;

    x0 |= y0;
    x1 |= y1;
    x0 |= z0;
    x1 |= z1;

    x0 |= x1;

    hkBool32 ovl = (~x0) & 0x8000;

    return ovl;
}



hkUint32 hkAabb16::yzDisjoint( const hkAabb16& a, const hkAabb16& b )
{
    union PointerUnion { const hkUint16* s; const hkUint32* i; };

    PointerUnion pamin; pamin.s = &a.m_min[1];
    PointerUnion pamax; pamax.s = &a.m_max[1];
    hkUint32 minA = *pamin.i;
    hkUint32 maxA = *pamax.i;

    PointerUnion pbmin; pbmin.s = &b.m_min[1];
    PointerUnion pbmax; pbmax.s = &b.m_max[1];
    hkUint32 minB = *pbmin.i;
    hkUint32 maxB = *pbmax.i;

    maxA -= minB;
    maxB -= minA;
    maxA |= maxB;
    return maxA & 0x80008000;
}



void hkAabb16::setIntersection( const hkAabb16& aabb0, const hkAabb16& aabb1  )
{
#if defined(HK_USING_GENERIC_INT_VECTOR_IMPLEMENTATION)
    {
        m_max[0] = hkMath::min2( aabb0.m_max[0], aabb1.m_max[0] );
        m_max[1] = hkMath::min2( aabb0.m_max[1], aabb1.m_max[1] );
        m_max[2] = hkMath::min2( aabb0.m_max[2], aabb1.m_max[2] );

        m_min[0] = hkMath::max2( aabb0.m_min[0], aabb1.m_min[0] );
        m_min[1] = hkMath::max2( aabb0.m_min[1], aabb1.m_min[1] );
        m_min[2] = hkMath::max2( aabb0.m_min[2], aabb1.m_min[2] );

    }
#else
    hkIntVector vmin; vmin.load<4>( (const hkUint32*)&aabb0 );
    hkIntVector vmax = vmin;
    hkIntVector a; a.load<4>( (const hkUint32*)&aabb1  );
    vmin.setMaxS16( vmin, a );
    vmax.setMinS16( vmax, a );
    vmax.store<4>( (hkUint32*)this);
    vmin.store<2>( (hkUint32*)this);
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
