// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#pragma once

#include <Common/Base/Math/Vector/hkIntVector.h>
struct hkAabb24_16_24;
/// Aabb using 15 bit storage (highest bit cannot be used).
/// You can use hkIntspaceUtil to convert back and forth this class.
struct HK_EXPORT_COMMON hkAabb16
{
    //+version(0)
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkAabb16 );
        HK_DECLARE_REFLECTION();

        //hkAabb16(){}

        template<typename KeyType>
        HK_INLINE void setKey(KeyType key);

        HK_INLINE void getKey(hkUint16& key) const;

        HK_INLINE void getKey(hkUint32& key) const;

        HK_INLINE void setEmpty();

        HK_INLINE   void setEndMarker();
        HK_INLINE bool isEndMarker() const;

        HK_INLINE void set( const hkAabb16& other );

        template<typename AABB, typename CODEC>         ///< implement for hkAabb16 and hkAabb24_16_24
        HK_INLINE void set2( const AABB& other, const CODEC& codec );

        HK_INLINE bool isEmpty() const;

        HK_INLINE bool isEqual(const hkAabb16& testAabb) const;

        HK_INLINE hkUint32 getMinXSortKey() const;
        HK_INLINE hkUint32 getMaxXSortKey() const;

        HK_INLINE friend hkBool32 operator < (const hkAabb16& a, const hkAabb16& b ) { return a.m_min[0] < b.m_min[0]; }

        HK_INLINE void getExtent(hkUint32 extent[3]) const;

        //HK_INLINE hkUint32 getMajorExtent() const;

        HK_ALWAYS_INLINE hkUint32 getMin( int i ) const { return m_min[ i ]; }
        HK_ALWAYS_INLINE hkUint32 getMax( int i ) const { return m_max[ i ]; }

        /// Return non-zero if the given AABB does not touch this one in any way.
        /// If a border touches, the AABBs are *not* considered disjoint.
        HK_INLINE hkBool32 disjoint(const hkAabb16& testAabb) const;

        /// Return non-zero if the given AABB overlaps with this one in any way.
        /// If a border touches, the AABBs *are* considered overlapping.
        HK_INLINE hkBool32 overlaps(const hkAabb16& testAabb) const;

        HK_INLINE void includePoint( hkUint32 c[3] );

        HK_INLINE void includeAabb( const hkAabb16& in );

        /// Set this to the extent of all input aabbs.
        void setExtents(_In_reads_(numAabbsIn) const hkAabb16* aabbsIn, int numAabbsIn );

        /// Set this to the extent of all input aabb centers, assumes that the bit 16 of the input aabbs is cleared
        void setExtentsOfCenters(_In_reads_(numAabbsIn) const hkAabb16* aabbsIn, int numAabbsIn );

        /// Sets this to the intersection of aabb0 and aabb1.
        HK_INLINE void setIntersection( const hkAabb16& aabb0, const hkAabb16& aabb1 );

        /// Sets this to the union of aabb0 and aabb1.
        HK_INLINE void setUnion( const hkAabb16& aabb0, const hkAabb16& aabb1 );

        /// returns true if test AABB is fully inside this, touching the border is allowed
        HK_INLINE hkBool32 contains( const hkAabb16& testAabb ) const;

        /// returns true if test AABB is fully inside this and is not touching the border
        HK_INLINE hkBool32 containsDontTouch( const hkAabb16& testAabb ) const;

        /// returns (min+max)  faster than getCenter()
        HK_INLINE void getCenter2(hkVector4& c) const;

        /// returns (max-min)  faster than getCenter()
        HK_INLINE void getExtents(hkVector4& e) const;

        static HK_INLINE hkUint32 yzDisjoint( const hkAabb16& a, const hkAabb16& b );

    public:

        HK_ALIGN16(hkUint16 m_min[3]);
        hkUint16 m_key;
        hkUint16 m_max[3];
        hkUint16 m_key1;
};


#include <Common/Base/Types/Geometry/Aabb16/hkAabb16.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
