// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

bool hkAabb::isValid() const
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    hkBool32 minOK = m_min.isOk<3>();
    hkBool32 maxOK = m_max.isOk<3>();
    hkBool32 minLEmax = m_min.lessEqual(m_max).allAreSet<hkVector4ComparisonMask::MASK_XYZ>();
    return minOK && maxOK && minLEmax;
#else
    for(int i = 0; i < 3; ++i)
    {
        if(     hkMath::isFinite(m_min(i)) == false
            ||  hkMath::isFinite(m_max(i)) == false
            ||  m_min(i) > m_max(i) )
        {
            return false;
        }
    }
    return true;
#endif
}


void hkAabb::includePoints(_In_reads_(numPoints) const hkVector4* p, int numPoints )
{
    hkAabb aabb = *this;    // make copy so the compiler can optimize
    for (int i =0; i < numPoints; i++ )
    {
        aabb.includePoint(p[i]);
    }
    *this = aabb;
}

void hkAabb::signedDistanceToPoint( const hkVector4& point, hkVector4& gradientAndDistanceOut ) const
{
    // Assume the point is outside.
    hkVector4 projection; projectPoint( point, projection );
    gradientAndDistanceOut = point - projection;
    gradientAndDistanceOut.setW( gradientAndDistanceOut.normalizeWithLength<3, HK_ACC_FULL, HK_SQRT_SET_ZERO>() );

    // Handle case where the point is inside or the distance is too small for the normal to be reliable.
    if ( gradientAndDistanceOut.getW() <= hkSimdReal_Eps )
    {
        const hkVector4 center = ( m_min + m_max ) * hkSimdReal_Inv2;
        const hkVector4 extents = ( m_max - m_min ) * hkSimdReal_Inv2;
        hkVector4 invExtents; invExtents.setReciprocal<HK_ACC_FULL, HK_DIV_SET_ZERO>( extents );
        hkVector4 delta; delta.setAbs( point - center );
        const int axis = ( delta * invExtents ).getIndexOfMaxComponent<3>();
        gradientAndDistanceOut( axis ) = hkReal( ( point - center )( axis ) < 0 ? -1 : +1 );
        gradientAndDistanceOut( 3 ) = -( extents - delta )( axis );
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
