// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Memory/Router/hkMemoryRouter.h>


/// This class performs the required initialization steps for a Havok worker thread like setting up the memory and base
/// systems. Create an object of this class in your worker thread before performing any Havok work. Object
/// destruction takes care of shutting down the context appropriately. See hkCpuThreadPool::threadMain for an example
/// of use.
class HK_EXPORT_COMMON hkWorkerThreadContext
{
    public:
        HK_DECLARE_CLASS(hkWorkerThreadContext, New);

        //// Thread IDs must be assigned sequentially starting from 1. ID 0 is used by the main Havok thread.
        hkWorkerThreadContext(int threadId);
        ~hkWorkerThreadContext();

    public:

        hkMemoryRouter m_memoryRouter;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
