// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Thread/hkWorkerThreadContext.h>

#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

#if defined(HK_COMPILER_HAS_INTRINSICS_IA32)
#   include <xmmintrin.h>
#endif

extern HK_EXPORT_COMMON HK_THREAD_LOCAL( int ) hkThreadNumber;

hkWorkerThreadContext::hkWorkerThreadContext(int threadId)
{
    // Flush all denormal/subnormal numbers (2^-1074 to 2^-1022) to zero.
    // Typically operations on denormals are very slow, up to 100 times slower than normal numbers.
#if defined(HK_COMPILER_HAS_INTRINSICS_IA32) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    _MM_SET_FLUSH_ZERO_MODE(_MM_FLUSH_ZERO_ON);
#elif defined(HK_ARCH_ARM_64) && defined(HK_COMPILER_MSVC)
    
    __int64 result = _ReadStatusReg(ARM64_FPCR);
    result |= (1 << 24);
    _WriteStatusReg(ARM64_FPCR, result);
#elif defined(HK_ARCH_ARM_64) && !defined(HK_COMPILER_MSVC)
    unsigned long result;
    asm volatile("mrs %[result], FPCR" : [result] "=r" (result));
    result |= (1 << 24);
    asm volatile("msr FPCR, %[src]" : : [src] "r" (result));
#elif defined(HK_ARCH_ARM) && defined(HK_COMPILER_MSVC)
    
    #define CPVFP_FPSCR 10, 7, 1, 0, 0
    int result =  _MoveFromCoprocessor(CPVFP_FPSCR);
    result |= (1 << 24);
    _MoveToCoprocessor(result, CPVFP_FPSCR);
#elif defined(HK_ARCH_ARM) && !defined(HK_PLATFORM_PSVITA) && !defined(HK_PLATFORM_WINRT)
    int result;
    asm volatile("vmrs %[result], FPSCR" : [result] "=r" (result));
    result |= (1 << 24);
    asm volatile("vmsr FPSCR, %[src]" : : [src] "r" (result));
#endif

    // Initialize memory system
    
    hkMemoryRouter& memoryRouter = m_memoryRouter;
    hkMemorySystem::getInstance().threadInit(memoryRouter, "hkWorkerThreadContext");
    hkBaseSystem::initThread(&m_memoryRouter);
    

    // Store thread id in thread local memory
    // This is only necessary if using hkJobQueue or hkCheckDeterminismUtil
    HK_THREAD_LOCAL_SET(hkThreadNumber, threadId);

    // Initializes determinism checking for this thread if determinism checking
    // is enabled. Does nothing otherwise.
    //
    // Note that determinism checking is for internal Havok use only, so if
    // customers want to write their own code to set up worker thread contexts,
    // then it's not necessary to include this.
    hkCheckDeterminismUtil::initThread();
}

hkWorkerThreadContext::~hkWorkerThreadContext()
{
    // Perform cleanup operations
    hkCheckDeterminismUtil::quitThread();

    
    hkBaseSystem::quitThread();
    hkMemorySystem::getInstance().threadQuit(m_memoryRouter);
    
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
