// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Config/hkConfigThread.h>
//HK_THREAD_LOCAL - declare a thread local variable
//HK_THREAD_LOCAL_SET(var,value) - assign to tls var
//HK_THREAD_LOCAL_GET(var) - get from tls var

#if (HK_CONFIG_THREAD == HK_CONFIG_MULTI_THREADED)
#   if defined(HK_PLATFORM_WINRT) || defined(HK_SUPPORT_DWM)
#       define HK_THREAD_LOCAL(TYPE) __declspec(thread) TYPE
#   elif defined(HK_PLATFORM_LINUX) || ( defined(HK_PLATFORM_ANDROID) && !defined(HK_COMPILER_CLANG) ) || defined(HK_PLATFORM_PS4) // || defined(HK_PLATFORM_TIZEN)
#       define HK_THREAD_LOCAL(TYPE) __thread TYPE
#   elif defined(HK_PLATFORM_NX)

#       include <stdint.h>
#       include <nn/nn_Macro.h>
#       include <nn/nn_Log.h>
#       include <nn/nn_Assert.h>
#       include <nn/os.h>

        template < typename T >
        class hkThreadLocalData
        {
        public:
            hkThreadLocalData() { nn::os::AllocateTlsSlot(&m_key, HK_NULL); }
            ~hkThreadLocalData() { nn::os::FreeTlsSlot(m_key); }

            HK_INLINE T getData()
            {
                return (T)nn::os::GetTlsValue(m_key);
            }

            
            HK_INLINE void setData(T p)
            {
                hkUlong v = hkUlong(p);
                nn::os::SetTlsValue(m_key, v);
            }

        protected:
            nn::os::TlsSlot m_key;
        };

#       define HK_THREAD_LOCAL(TYPE) hkThreadLocalData<TYPE>
#       define HK_THREAD_LOCAL_SET(var,value) var.setData(value)
#       define HK_THREAD_LOCAL_GET(var) var.getData()

#   elif defined(HK_PLATFORM_WIN32)

        #define HK_WIN32_TLS_INVALID ((hkUint32)0xFFFFFFFF)

        extern "C" {
        #if defined(HK_PLATFORM_WIN32)
            _Must_inspect_result_ __declspec(dllimport) unsigned long _stdcall TlsAlloc(void);
            __declspec(dllimport) void* _stdcall TlsGetValue(_In_ unsigned long dwTlsIndex);
            __declspec(dllimport) int _stdcall TlsSetValue(_In_ unsigned long dwTlsIndex, _In_opt_ void* lpTlsValue);
            __declspec(dllimport) int _stdcall TlsFree(_In_ unsigned long dwTlsIndex);
        #else
            unsigned long __stdcall TlsAlloc(void);
            void* __stdcall TlsGetValue(unsigned long dwTlsIndex);
            int __stdcall TlsSetValue(unsigned long dwTlsIndex, void* lpTlsValue);
            int __stdcall TlsFree(unsigned long dwTlsIndex);
        #endif
        }

        /// A platform independent wrapper for thread local storage.
        /// We assume we always just store a pointer (or data the same size or smaller than a pointer)
        /// i.e., sizeof(T) <= sizeof(char*).
        /// In debug it will now stop when platform limits are reached as it will soon cause a crash anyway
        /// such as threadmem being null etc
        template<typename T>
        class hkThreadLocalData
        {
            public:

                hkThreadLocalData()
                {
                    m_slotID = TlsAlloc();
                    HK_ON_DEBUG(if (m_slotID == HK_WIN32_TLS_INVALID) { HK_BREAKPOINT(0xabba3651); })
                }
                ~hkThreadLocalData()
                {
                    HK_ON_DEBUG(int r = ) TlsFree(m_slotID);
                    HK_ON_DEBUG(if (r == 0) { HK_BREAKPOINT(0xabba3652); })
                }
                HK_INLINE T getData() const
                {
                    return (T)(hkUlong)TlsGetValue(m_slotID);
                }
                HK_INLINE void setData(T p)
                {
                    hkUlong v = hkUlong(p);
                    HK_ON_DEBUG(int r = ) TlsSetValue(m_slotID, (void*)v);
                    HK_ON_DEBUG(if (r == 0) { HK_BREAKPOINT(0xabba3653); })
                }
                unsigned long m_slotID;
        };

#       define HK_THREAD_LOCAL(TYPE) hkThreadLocalData<TYPE>
#       define HK_THREAD_LOCAL_SET(var,value) var.setData(value)
#       define HK_THREAD_LOCAL_GET(var) var.getData()
#   elif defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_LRB) || defined(HK_PLATFORM_TIZEN) || defined(HK_PLATFORM_ANDROID) // && defined(HK_ARCH_IA32)

#       ifdef HK_PLATFORM_LRBSIM
#       include <common/winpthread.h>
#       else
#       include <pthread.h> 
#       endif

            template < typename T >
            class hkThreadLocalData
            {
                public:
                    hkThreadLocalData() { pthread_key_create(&m_key, HK_NULL); }
                    ~hkThreadLocalData() { pthread_key_delete(m_key); }

                    HK_INLINE T getData() const
                    {
                        void* data = pthread_getspecific(m_key);
                        return *reinterpret_cast<T*>( &data );
                    }

                    HK_INLINE void setData(T p)
                    {
                        pthread_setspecific(m_key, reinterpret_cast<void*>( p ) );
                    }

                protected:
                    pthread_key_t m_key;
            };
#       define HK_THREAD_LOCAL(TYPE) hkThreadLocalData<TYPE>
#       define HK_THREAD_LOCAL_SET(var,value) var.setData(value)
#       define HK_THREAD_LOCAL_GET(var) var.getData()

#   elif defined(HK_PLATFORM_WIIU)
        // Starting with SDK 2.10.00, WiiU has compiler support for TLS
#       if (CAFE_OS_SDK_VERSION > 21000)
#           define HK_THREAD_LOCAL(TYPE) __thread TYPE
#           define HK_WIIU_USING_COMPILER_TLS 1
#       else
        // Else use an explicit TLS
#           include <Common/Base/Thread/Thread/WiiU/hkThreadLocalDataWiiU.h>
#       endif
#   elif defined(HK_PLATFORM_PSVITA)

#       define HK_THREAD_LOCAL(TYPE) __declspec(thread) TYPE
#   else
#       error fixme, unkown MT platform for TLS
#   endif
#else
#   define HK_THREAD_LOCAL(TYPE) TYPE
#endif

#if defined(HK_THREAD_LOCAL_SET) != defined(HK_THREAD_LOCAL_GET)
    #error Define both HK_THREAD_LOCAL_SET and HK_THREAD_LOCAL_GET or neither.
#endif

#if defined(HK_THREAD_LOCAL_SET)
    #define HK_THREAD_LOCAL_COMPILER_SUPPORT 0
#else
    #define HK_THREAD_LOCAL_COMPILER_SUPPORT 1
    #define HK_THREAD_LOCAL_SET(var,value) var = value
    #define HK_THREAD_LOCAL_GET(var) var
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
