// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// A platform independent wrapper for a thread
class HK_EXPORT_COMMON hkThread
{
public:

        /// On Win32 and Xbox360, a stack size of 0 means the thread defaults to the executable's stack size
        /// On other platforms (e.g. posix), this is ignored.
        enum
        {
            #if defined(HK_PLATFORM_PS4)
            #   ifdef HK_DEBUG
                    HK_THREAD_DEFAULT_STACKSIZE = 0x80000,
            #   else
                    HK_THREAD_DEFAULT_STACKSIZE = 0x20000,
            #   endif
            #elif defined(HK_PLATFORM_NX)
                    HK_THREAD_DEFAULT_STACKSIZE = 0x20000,
            #else
                    HK_THREAD_DEFAULT_STACKSIZE = 0,
            #endif
        };

        enum Status
        {
            THREAD_TERMINATED,
            THREAD_RUNNING,
            THREAD_NOT_STARTED
        };

        typedef void* (HK_CALL *StartFunction)(void*);

    public:

        HK_DECLARE_CLASS(hkThread, New, NonCopyable);

        hkThread();

        ~hkThread();

        hkResult startThread(StartFunction f, _Inout_opt_ void*, _In_z_ const char* name, int threadStackSize = HK_THREAD_DEFAULT_STACKSIZE);

        /// Wait for the thread to complete and release the associated kernel resource.
        void joinThread();

        Status getStatus() const;

        hkUint64 getChildThreadId() const;

        _Ret_maybenull_ void* getHandle();

        /// Sets the priority of this thread. Threads with a higher priority
        /// number are given priority over threads with lower priority by the
        /// scheduler. A priority in the range [-2, 2] is guaranteed to work on
        /// all platforms, other values might work on some, but not on other
        /// platforms. When a thread is created, it has the default priority of 0.
        void setPriority(int priority = 0);

        /// Gets the priority of this thread.
        int getPriority() const;

        /// returns the id of the calling thread.
        static hkUint64 HK_CALL getMyThreadId();

        /// Sets this threads preferred HW thread (soft-affinitizes).
        void setIdealProcessor(int hardwareThreadId);

        /// Hard-affinitizes the current software thread to HW threads enabled
        /// in mask.
        void setThreadAffinityMask(hkUint32 mask);

    private:

#ifndef HK_PLATFORM_WIN32
        static void* HK_CALL threadStartWrapper(void* param);   
#endif

        void* m_thread;
        hkUint64 m_threadId;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
