// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Thread/hkThread.h>

#ifdef HK_PLATFORM_WIN32
#   include <Common/Base/Fwd/hkwindows.h>
#endif

hkThread::hkThread()
    : m_thread(HK_NULL)
{
}

hkThread::~hkThread()
{
    joinThread();
}

void hkThread::joinThread()
{
    if( m_thread )
    {
        WaitForSingleObject( m_thread, INFINITE );
        CloseHandle( m_thread );
        m_thread = HK_NULL;
    }
}


// Taken from XeDK documentation, works on Win32 on Visual Studio 2008 too.
typedef struct tagTHREADNAME_INFO {
    DWORD dwType;     // Must be 0x1000
    LPCSTR szName;    // Pointer to name (in user address space)
    DWORD dwThreadID; // Thread ID (-1 for caller thread)
    DWORD dwFlags;    // Reserved for future use; must be zero
} THREADNAME_INFO;

hkResult hkThread::startThread(hkThread::StartFunction func, _Inout_opt_ void* arg, _In_z_ const char* name, int stackSize)
{
    // We create the thread in suspended mode, and then resume it later on, to
    // make sure that the m_thread field of this hkThread is initialized when
    // the thread's main function starts running.

    DWORD tempThreadId;
    m_thread = CreateThread(
        HK_NULL,                        //LPSECURITY_ATTRIBUTES ThreadAttributes,
        stackSize ,                     //DWORD StackSize,
        (LPTHREAD_START_ROUTINE)func,   //LPTHREAD_START_ROUTINE StartAddress,
        arg,                            //LPVOID Parameter,
        CREATE_SUSPENDED,               //DWORD CreationFlags,
        (LPDWORD)&tempThreadId          //LPDWORD ThreadId
        );

    if (m_thread == HK_NULL)
    {
        return HK_FAILURE;
    }
    else
    {
        m_threadId = (hkUint32) tempThreadId;

#if !defined(_MSC_VER) ||  (_MSC_VER < 1700) // Not understood by VS2012
        // Set thread name
        THREADNAME_INFO info;

        info.dwType = 0x1000;
        info.szName = name;
        info.dwThreadID = tempThreadId;
        info.dwFlags = 0;

        __try
        {
            RaiseException( 0x406D1388, 0, sizeof(info)/sizeof(DWORD), (CONST ULONG_PTR *)(&info) );
        }
        __except( GetExceptionCode()==0x406D1388 ? EXCEPTION_CONTINUE_EXECUTION : EXCEPTION_EXECUTE_HANDLER )
        {
        }
#endif

        ResumeThread(m_thread);

        return HK_SUCCESS;
    }
}

hkThread::Status hkThread::getStatus() const
{
    if (m_thread == HK_NULL)
    {
        return THREAD_NOT_STARTED;
    }
    DWORD exitCode;
    GetExitCodeThread( m_thread,&exitCode);
    if ( exitCode == STILL_ACTIVE )
    {
        return THREAD_RUNNING;
    }
    return THREAD_TERMINATED;
}


hkUint64 HK_CALL hkThread::getMyThreadId()
{
    return (hkUint64)GetCurrentThreadId();
}

hkUint64 hkThread::getChildThreadId() const
{
    return m_threadId;
}

_Ret_maybenull_ void* hkThread::getHandle()
{
    return m_thread;
}

void hkThread::setPriority(int priority)
{
    HK_ON_DEBUG(BOOL success =) SetThreadPriority(m_thread, priority);
    HK_ASSERT(0x41c9e8cf, success, "Call to SetThreadPriority failed with error {}.", GetLastError());
}

int hkThread::getPriority() const
{
    int ret = GetThreadPriority(m_thread);
    HK_ASSERT(0x42858996, ret != THREAD_PRIORITY_ERROR_RETURN, "Call to GetThreadPriority failed with error code {}.", GetLastError());
    return ret;
}

void hkThread::setIdealProcessor(int hardwareThreadId)
{
#if defined(HK_PLATFORM_DURANGO)
    PROCESSOR_NUMBER pp, prevPP;
    pp.Group = 0;
    pp.Number = ( BYTE ) hardwareThreadId;
    SetThreadIdealProcessorEx(m_thread, &pp, &prevPP );
#elif defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT)
    SetThreadIdealProcessor(m_thread, hardwareThreadId );
#endif
}

void hkThread::setThreadAffinityMask(hkUint32 mask)
{
    SetThreadAffinityMask(m_thread, (DWORD_PTR) mask);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
