// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ANDROID IOS NX32 NX64 !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#ifdef HK_ARCH_ARM
#if defined(HK_ARCH_ARM_64)
    #define hkArmMemBarrier() __asm__ __volatile__("": : :"memory")
#else
    #define hkArmMemBarrier() __asm__ __volatile__("dmb": : :"memory")
#endif

// Intrinic like ver of LDREX (handy for more readable code)
inline hkUint32 hk_ldrex(volatile hkUint32* v)
{
    hkUint32 ret;
#if defined(HK_ARCH_ARM_64)
    hkUint64 ret64;
    __asm__ __volatile__(
         "  ldxr   %0, [%1]\n"
         : "=&r" (ret64)
         : "r" (v)
         :
         );
    ret = (hkUint32)ret64;
#else
    __asm__ __volatile__(
        "     ldrex   %0, [%1]\n"
        : "=&r" (ret)
        : "r" (v)
        :
        );
#endif
    return ret;
}

inline hkUint32 hk_strex(hkUint32 s, volatile hkUint32* v)
{
    hkArmMemBarrier();

    hkUint32 ret;

#if defined(HK_ARCH_ARM_64)
    __asm__ __volatile__(
        "\tstxr   %w0, %w2, [%1]\n"
        : "=&r" (ret)
        : "r" (v), "r" (s)
        :
        );
#else
    __asm__ __volatile__(
        "\tstrex   %0, %2, [%1]\n"
        : "=&r" (ret)
        : "r" (v), "r" (s)
        :
        );
#endif
    return ret;
}

inline hkUint32 hk_atomic_add(volatile hkUint32* ptr, hkInt32 value)
{
    hkUint32 o;
    hkUint32 n;
    do
    {
        o = hk_ldrex(ptr);
        n = o + value;
    } while (hk_strex(n, ptr) != 0);

    hkArmMemBarrier(); // make sure no code can run after the incl until it is complete

    return o;
}

#endif // :Arm only

#if !defined(HK_PLATFORM_NX)
// x86/Arm agnostic:
#include <pthread.h>
inline hkUint32 hk_threadid()
{
    pthread_t tid = pthread_self();
    return (hkUint32) ((hkUlong)tid);
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
