// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


/// This task type enum is used to create unique frame IDs for the check determinism util (see hkCheckDeterminismUtil::Fuid).
/// If your task does not require any of these things then it does not need to have a task type here.
struct hkTaskType
{
    enum
    {
        // We start assigning values from 100 on to avoid overlapping with the values defined in hkJobType
        JOB_TYPE_MAX = 99,

        //
        // Physics tasks
        //
        HKNP_NARROW_PHASE_TASK,
        HKNP_POST_COLLIDE_TASK,
        HKNP_PRE_SOLVE_TASK,
        HKNP_SOLVER_TASK,
        HKNP_POST_SOLVE_TASK,
        HKNP_SOLVE_FINALIZE_TASK,
        HKNP_COLLISION_QUERY_TASK,
        HKNP_RAYCAST_TASK,
        HKNP_CHARACTER_PROXY_TASK,
        HKNP_WORLD_SHIFT_TASK,
        HKNP_FULL_CAST_TASK,

        //
        // Destruction tasks
        //
        HKND_PROJECT_MANIFOLD_TASK,
        HKND_PRE_SOLVE_TASK,
        HKND_POST_SOLVE_TASK,
        HKND_POST_PROJECT_TASK,
        HKND_SCHEDULE_SIM_STATES_TASK,
        HKND_CREATE_NEW_BODIES_TASK,
        HKND_CREATE_FORCE_GENERATORS_TASK,
        HKND_CREATE_SOLVER_CONNECTIONS_TASK,
        HKND_CREATE_SOLVER_BODIES_TASK,
        HKND_MERGE_LEAF_STREAMS_TASK,
        HKND_MERGE_HIT_POINTS_TASK,
        HKND_MERGE_BODY_STREAMS_TASK,
        HKND_MERGE_CONN_STREAMS_TASK,
        HKND_MERGE_FORCE_GENERATORS_TASK,
        HKND_MERGE_BODY_SEQUENCES_TASK,
        HKND_MERGE_CONN_SEQUENCES_TASK,
        HKND_MERGE_FRAGMENT_STREAMS_TASK,
        HKND_MERGE_DEFORMED_BODY_IDS_TASK,
        HKND_REMOVE_BROKEN_BODIES_TASK,
        HKND_CHECK_SOLVER_BODIES_DETERMINISM_TASK,
        HKND_UPDATE_DEFORMED_BODIES_TASK,

        //
        // AI tasks
        //
        HKAI_PATHFINDING_TASK,
        HKAI_VOLUME_PATHFINDING_TASK,
        HKAI_LOCAL_STEERING_TASK,
        HKAI_DYNAMIC_NAVMESH_TASK,

        // No ELFs associated with these, just for determinism fuids
        HKAI_NAVMESH_GENERATION_TASK,
        HKAI_NAVMESH_CLUSTERING_TASK,
        HKAI_NAVVOLUME_GENERATION_TASK,

        // Behavior tasks (no ELFs associated with these, just for determinism fuids)
        HKB_GENERATE_BEHAVIOR_GRAPH_TASK,
        HKB_GENERATE_NODES_TASK,
        HKB_UPDATE_CHARACTER_TASK,
    };
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
