// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkTaskGraph::TaskIdMapping::TaskIdMapping(int baseIdx)
    : m_baseTaskIndex(baseIdx)
{
}

HK_INLINE hkTaskGraph::TaskId hkTaskGraph::TaskIdMapping::getMappedId(TaskId in) const
{
    if(in.isValid())
    {
        return TaskId(m_baseTaskIndex + in.value());
    }

    return TaskId::invalid();
}

HK_INLINE bool hkTaskGraph::isEmpty() const
{
    return m_nodes.isEmpty() && m_dependencies.isEmpty();
}

HK_INLINE void hkTaskGraph::addDependency( TaskId predecessorId, TaskId successorId )
{
    HK_ASSERT( 0x386b8d39, predecessorId.isValid() && predecessorId.valueUnchecked() < m_nodes.getSize(), "Invalid predecessor ID" );
    HK_ASSERT( 0x386b8d3a,   successorId.isValid() &&   successorId.valueUnchecked() < m_nodes.getSize(), "Invalid successor ID" );
    HK_ASSERT( 0x4211a96d, predecessorId != successorId, "A task cannot depend on itself" );
    HK_ASSERT(0x6e705734, hasTransitiveDependency(successorId, predecessorId) == false, "Cycles in dependencies are not allowed" );
#if defined(HK_DEBUG_SLOW)
    if (hasDependency(predecessorId, successorId))
    {
        HK_WARN(0x4fae4485, "Duplicate dependency added");
    }
#endif
    Dependency& dependency = m_dependencies.expandOne();
    dependency.m_predecessorId = predecessorId;
    dependency.m_successorId = successorId;
}

HK_INLINE bool hkTaskGraph::tryAddDependency( TaskId predecessorId, TaskId successorId )
{
    if( predecessorId.isValid() && successorId.isValid() )
    {
        addDependency( predecessorId, successorId );
        return true;
    }
    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
