// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/TaskQueue/hkTaskQueue.h>

/// A simple task queue implementation, which executes tasks on a single thread. This class is intended
/// to be used to process tasks and task graphs in simple situations where no other task queue is
/// available and where multithreading is not desired.
class HK_EXPORT_COMMON hkTrivialTaskQueue : public hkTaskQueue
{
public:

    HK_DECLARE_CLASS(hkTrivialTaskQueue, New);

    hkTrivialTaskQueue() {}

    virtual void allocateHandles(_Inout_updates_bytes_(numHandles * striding) Handle* handlesOut, _In_range_(>= , 0) int numHandles, _In_range_(>= , sizeof(Handle*)) int striding = sizeof(Handle)) HK_OVERRIDE;

    virtual void freeHandles(_Inout_updates_bytes_(numHandles * striding) Handle* handles, _In_range_(>= , 0) int numHandles, _In_range_(>= , sizeof(Handle*)) int striding = sizeof(Handle)) HK_OVERRIDE;

    virtual void initHandle(Handle handle, _In_ hkTask* task, enum hkTask::Priority::Enum priority = hkTask::Priority::MEDIUM) HK_OVERRIDE;

    virtual void setMultiplicity(Handle handle, int multiplicity, hkTask::MultiplicityMode::Enum mode = hkTask::MultiplicityMode::PERFORM_ALL_CALLS) HK_OVERRIDE;

    virtual void addDependency(Handle predecessor, Handle successor) HK_OVERRIDE;

    virtual void submitHandles(_Inout_updates_bytes_(numHandles * striding) Handle* handles, int numHandles, Order::Enum order = Order::FIFO, int striding = sizeof(Handle)) HK_OVERRIDE;

    virtual void processUntilFinished(Handle handle) HK_OVERRIDE;

    virtual void submitGraphAndWait(struct hkTaskGraph& graph, Order::Enum order = Order::FIFO) override;

    virtual int getNumThreadsHint() const override { return 1; }

    struct HandleImpl;
private:
    hkArray<HandleImpl*> m_submittedHandles;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
