// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/TaskQueue/Trivial/hkTrivialTaskQueue.h>
#include <Common/Base/Container/MinHeap/hkMinHeap.h>
#include <Common/Base/Thread/TaskQueue/hkTaskGraph.h>

struct hkTrivialTaskQueue::HandleImpl
{
    HK_DECLARE_CLASS(HandleImpl, New);

    HandleImpl()
        : m_task(HK_NULL)
        , m_priority(hkTask::Priority::MEDIUM)
        , m_numOutstandingDependencies(0)
        , m_multiplicity(1)
        , m_processed(false) { }
    hkTask* m_task;
    hkEnum < hkTask::Priority::Enum, hkUint8> m_priority;
    int m_numOutstandingDependencies;
    int m_multiplicity;
    hkBool m_processed;
    hkInplaceArray<HandleImpl*, 2> m_dependants;
};

template <>
struct hkMinHeapDefaultOperations<hkTrivialTaskQueue::HandleImpl*>
{
public:
    HK_DECLARE_CLASS(hkMinHeapDefaultOperations, NewPlacement, ReflectIdentity);

    HK_INLINE static hkBool32 lessThan(_In_ hkTrivialTaskQueue::HandleImpl* a, _In_ hkTrivialTaskQueue::HandleImpl* b) { return (a->m_priority < b->m_priority); }
    /// Set index
    HK_INLINE static void setIndex(_In_opt_ hkTrivialTaskQueue::HandleImpl* a, int index) {}
    /// Swap
    HK_INLINE static void swap(hkTrivialTaskQueue::HandleImpl*& a, hkTrivialTaskQueue::HandleImpl*& b) { hkMath::swap(a, b); }
    /// Returns true if the index is correct.
    HK_INLINE static hkBool32 hasIndex(_In_ hkTrivialTaskQueue::HandleImpl* a, int i) { return true; }
};

void hkTrivialTaskQueue::allocateHandles(_Inout_updates_bytes_(numHandles * striding) Handle* handlesOut, _In_range_(>= , 0) int numHandles, _In_range_(>= , sizeof(Handle*)) int striding /*= sizeof(Handle)*/)
{
    for (int i = 0; i < numHandles; i++)
    {
        // Recomputing the full offset makes it easier for OACR to validate the memory accesses
        Handle* handleCur = hkAddByteOffset(handlesOut, i * striding);
        HandleImpl** h = reinterpret_cast<HandleImpl**>(handleCur);
        *h = new HandleImpl;
    }
}

void hkTrivialTaskQueue::initHandle(Handle handle_, _In_ hkTask* task, hkTask::Priority::Enum priority)
{
    HandleImpl* handle = reinterpret_cast<HandleImpl*>(handle_);
    handle->m_task = task;
    handle->m_priority = priority;
}

void hkTrivialTaskQueue::setMultiplicity(Handle handle_, int multiplicity, hkTask::MultiplicityMode::Enum mode )
{
    if(mode == hkTask::MultiplicityMode::PERFORM_ALL_CALLS)
    {
        HandleImpl* handle = reinterpret_cast<HandleImpl*>(handle_);
        handle->m_multiplicity = multiplicity;
    }
}

void hkTrivialTaskQueue::addDependency(Handle predecessor_, Handle successor_)
{
    HandleImpl* predecessor = reinterpret_cast<HandleImpl*>(predecessor_);
    HandleImpl* successor = reinterpret_cast<HandleImpl*>(successor_);

    predecessor->m_dependants.pushBack(successor);
    successor->m_numOutstandingDependencies++;
}

void hkTrivialTaskQueue::submitHandles(_Inout_updates_bytes_(numHandles * striding) Handle* handles, int numHandles, Order::Enum order /*= Order::FIFO*/, int striding /*= sizeof(Handle)*/)
{
    Handle* src         = handles;
    HandleImpl** dst    = m_submittedHandles.expandBy(numHandles);

    for(int i = 0; i < numHandles; i++)
    {
        dst[i] = reinterpret_cast<HandleImpl*>(*src);
        src = hkAddByteOffset(src, striding);
    }
}

void hkTrivialTaskQueue::processUntilFinished(Handle targetHandle_)
{
    HandleImpl* targetHandle = reinterpret_cast<HandleImpl*>(targetHandle_);

    hkMinHeap<HandleImpl*> readyHandles;
    for(int ih = 0; ih < m_submittedHandles.getSize(); ih++)
    {
        if(m_submittedHandles[ih]->m_numOutstandingDependencies == 0)
        {
            readyHandles.addEntry(m_submittedHandles[ih]);
        }
    }

    while(!readyHandles.isEmpty())
    {
        HandleImpl* handle = readyHandles.getTop();
        readyHandles.popTop();

        if(handle->m_task)
        {
            hkTask::Input input;
            input.m_taskQueue = this;
            for(int i = 0; i<handle->m_multiplicity; i++)
            {
                input.m_multiplicityIndex = i;
                handle->m_task->process(input);
            }

        }

        handle->m_processed = true;

        for(int id = 0; id < handle->m_dependants.getSize(); id++)
        {
            HandleImpl* dependant = handle->m_dependants[id];
            HK_ASSERT_NO_MSG(0xf987a3b2, dependant->m_numOutstandingDependencies > 0);
            dependant->m_numOutstandingDependencies--;

            if(dependant->m_numOutstandingDependencies == 0)
            {
                readyHandles.addEntry(dependant);
            }
        }

        if(handle == targetHandle)
        {
            break;
        }
    }

    HK_ASSERT_NO_MSG(0x9475987a, targetHandle->m_processed);

    for(int ih = 0; ih < m_submittedHandles.getSize();)
    {
        if(m_submittedHandles[ih]->m_processed)
        {
            m_submittedHandles.removeAt(ih);
        }
        else
        {
            ih++;
        }
    }
}

void hkTrivialTaskQueue::submitGraphAndWait(struct hkTaskGraph& graph, Order::Enum order /*= Order::FIFO*/)
{
    // To make this reentrant (that is, submitGraphAndWait can be called from within a task), we construct a second
    // task queue solely for this task graph.
    hkTrivialTaskQueue taskQueue;
    graph.submitToTaskQueueAndWait(taskQueue, order);
}

void hkTrivialTaskQueue::freeHandles(_Inout_updates_bytes_(numHandles * striding) Handle* handles, _In_range_(>= , 0) int numHandles, _In_range_(>= , sizeof(Handle*)) int striding /*= sizeof(Handle)*/)
{
    for (int i = 0; i < numHandles; i++)
    {
        // Recomputing the full offset makes it easier for OACR to validate the memory accesses
        Handle* handleCur = hkAddByteOffset(handles, i * striding);
        HandleImpl** h = reinterpret_cast<HandleImpl**>(handleCur);
        delete *h;
        *h = HK_NULL;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
