// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Thread/TaskQueue/Default/hkDefaultTaskQueue_HandleImpl.h>


/// Optional logger which can help debugging.
/// Logs submitted tasks and dependencies so that you can get a history of inputs to a task queue.
class hkDefaultTaskQueue::Logger
{
    public:

        // Dummy task storing a copy of some strings from another task
        struct LoggedTask : public hkReferencedTask
        {
            HK_DECLARE_CLASS( LoggedTask, New );

            virtual const char* getName() const HK_OVERRIDE
            {
                return m_name;
            }

            virtual void getDebugAttributes( DebugAttributes& attributesOut ) const HK_OVERRIDE
            {
                attributesOut.m_extraInfo = m_extraInfo;
                attributesOut.m_category = m_category;
            }

            virtual void process( const hkTask::Input& ) HK_OVERRIDE
            {
                // This should never be called
                HK_ASSERT_NO_MSG( 0x18ff3e6f, false );
            }

            hkStringPtr m_name;
            hkStringPtr m_extraInfo;
            hkTask::DebugAttributes::TaskCategory m_category;
            hkTaskGraph::TaskId m_id;
        };

    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, Logger);

        // Log a handle
        HK_INLINE void logHandle(_Inout_ HandleImpl* handle)
        {
            m_lock.enter();

            hkTask::DebugAttributes debugAttributes;
            handle->m_task->getDebugAttributes(debugAttributes);

            LoggedTask* loggedTask = new LoggedTask();
            loggedTask->m_name = handle->m_task->getName();
            loggedTask->m_extraInfo = debugAttributes.m_extraInfo;
            loggedTask->m_category = debugAttributes.m_category;
            loggedTask->m_id = m_graph.addReferencedTask(loggedTask);
            loggedTask->removeReference();

            m_handleToLoggedTask.insert( handle, loggedTask );

            m_lock.leave();
        }

        // Log a dependency
        HK_INLINE void logDependency(_Inout_ HandleImpl* predecessor, _Inout_ HandleImpl* successor )
        {
            m_lock.enter();

            LoggedTask* p = m_handleToLoggedTask.getWithDefault( predecessor, HK_NULL );
            LoggedTask* s = m_handleToLoggedTask.getWithDefault( successor, HK_NULL );
            if( p && s )
            {
                m_graph.addDependency( p->m_id, s->m_id );
            }

            m_lock.leave();
        }

    public:

        // Task graph for tracing tasks and dependencies
        hkTaskGraph m_graph;

        // Map from task handle to logged task ptr
        hkMap< HandleImpl*, LoggedTask* > m_handleToLoggedTask;

        // Critical section used for protecting concurrent access
        hkCriticalSection m_lock;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
