// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#if defined(HK_COMPILER_MSVC) || defined(HK_COMPILER_INTEL)
#   pragma warning( 3 : 4820 )      
#endif

template<typename UNIT, unsigned NBIT>
class hkFixedBitfield
{
public:

    HK_DECLARE_CLASS(hkFixedBitfield, New);
    typedef UNIT Unit;
    enum
    {
        NUM_BITS = NBIT,
        BITS_PER_UNIT = sizeof(UNIT) * 8,
        NUM_UNIT = HK_NEXT_MULTIPLE_OF(BITS_PER_UNIT, NBIT) / BITS_PER_UNIT,
    };

    void clear()
    {
        for (int i = 0; i < NUM_UNIT; ++i) { m_units[i] = 0; }
    }
    Unit getUnit(int i) const
    {
        return m_units[i];
    }
    bool isClear(int i) const
    {
        int ui = unsigned(i) / BITS_PER_UNIT;
        int bi = unsigned(i) % BITS_PER_UNIT;
        return (m_units[ui] & (Unit(1) << bi)) == 0;
    }
    void setBit(int i)
    {
        int ui = unsigned(i) / BITS_PER_UNIT;
        int bi = unsigned(i) % BITS_PER_UNIT;
        m_units[ui] |= Unit(1) << bi;
    }
    void clearBit(int i)
    {
        int ui = unsigned(i) / BITS_PER_UNIT;
        int bi = unsigned(i) % BITS_PER_UNIT;
        m_units[ui] &= ~(Unit(1) << bi);
    }
    Unit anyIsSet() const
    {
        Unit  r = m_units[0];
        for (int i = 1; i < NUM_UNIT; ++i) { r |= m_units[i]; }
        return r;
    }
    hkFixedBitfield& operator|=(const hkFixedBitfield& f)
    {
        for (int i = 0; i < NUM_UNIT; ++i) { m_units[i] |= f.m_units[i]; }
        return *this;
    }
    hkFixedBitfield& operator&=(const hkFixedBitfield& f)
    {
        for (int i = 0; i < NUM_UNIT; ++i) { m_units[i] &= f.m_units[i]; }
        return *this;
    }
protected:
    Unit m_units[NUM_UNIT];
};


/// Handle implementation used by hkDefaultTaskQueue.
class hkDefaultTaskQueue::HandleImpl
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, HandleImpl );

        HK_ALWAYS_INLINE bool isAllocated() const   {   return m_dependencyCount != hkUint16(-2);   }
        HK_ALWAYS_INLINE bool isInitialized() const {   return m_task != HK_NULL;                   }
        HK_ALWAYS_INLINE bool isSubmitted() const   {   return m_sortKey != 0;                      }
        HK_ALWAYS_INLINE bool isAvailable() const   {   return m_dependencyCount == hkUint16(0);    }
        HK_ALWAYS_INLINE bool isFinished() const    {   return m_dependencyCount == hkUint16(-1);   }

    public:

        // A capacity chosen for optimal packing.
        enum
        {
        #if HK_POINTER_SIZE == 8
            NUM_INPLACE_SUCCESSORS = 2
        #else
            NUM_INPLACE_SUCCESSORS = 4
        #endif
        };

    public:

        enum
        {
            NUM_PRIORITY_BITS = 8,
            NUM_SERIAL_BITS = 24,
        };

        /// A priority value used to sort available handles.
        hkUint32 m_sortKey;

        /// The current number of unfinished predecessors.
        /// This handle can only be processed when this value equals zero.
        /// Special values:
        ///  * -1 after the handle has been processed.
        ///  * -2 for free handles.
        hkUint16 m_dependencyCount;

        /// The (maximum) remaining number of times this task needs to run.
        hkUint16 m_multiplicity;

        /// The number of threads working on this item.
        hkUint16 m_numActiveThreads;

        /// If this is set, any finish call to this task will set its multiplicity to 0.
        hkBool m_onFinishZeroMultiplicity;

        /// The global priority of this handle, set by the user.
        hkEnum<hkTask::Priority::Enum, hkUint8> m_priority;

        /// A tag added to the monitor stream of the thread when it submitted this handle.
        hkUint32 m_parentMonitorStreamTag;

        /// The abort request. If set, it instructs the task to abort its execution.
        hkAtomic::Variable<hkBool32> m_abortRequest;

        /// The vertexId in the graph used to determine the set of handles to be canceled.
        int m_graphVertexId;

        /// A bitfield of thread indices that are waiting for this handle to be finished.
        typedef hkFixedBitfield<hkUint64, hkDefaultTaskQueue::MAX_NUM_THREADS> WaitingThreadsBitfield;
        WaitingThreadsBitfield m_waitingThreadsBitfield;    

        /// An array of successor handles.
        /// Their dependency counts should be decremented after this handle has been processed.
        hkInplaceArray< HandleImpl*, NUM_INPLACE_SUCCESSORS > m_successors;

        /// Handles which are currently waiting for this handle. All accesses must be guarded by the task queue lock.
        hkInplaceArray<HandleImpl*, 1> m_waitingHandles;

        union
        {
            /// The task to process, if this handle is allocated (m_dependencyCount != -2).
            /// Must be non-null for initialized handles.
            class hkTask* m_task;

            /// The next handle in the free list, if this handle is free (m_dependencyCount == -2).
            /// Set to HK_NULL to mark the end of the free list.
            HandleImpl* m_nextFreeHandle;
        };
};

#if defined(HK_PLATFORM_WIN32)
#   pragma warning( disable : 4820 )
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
