// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Config/hkConfigThread.h>

#if (defined(HK_PLATFORM_IOS) && !defined(HK_PLATFORM_IOS_SIM))

class HK_EXPORT_COMMON hkSemaphoreBusyWait
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkSemaphoreBusyWait);

    /// Create a semaphore with an initial count and a maximum count. Max count currently ignored.
    hkSemaphoreBusyWait( int initialCount = 0, int maxCount = 1000);

    /// Destruct the Semaphore
    ~hkSemaphoreBusyWait();

    /// This call will block until the semaphore is released.
    void acquire();

    /// Release the semaphore. Releases a thread blocked by acquire().
    void release(int count = 1);

    // These static functions used for PlayStation(R)3 compat
    static void HK_CALL acquire(_Inout_ hkSemaphoreBusyWait* semaphore);
    static void HK_CALL release(_Inout_ hkSemaphoreBusyWait* semaphoreu, int count = 1);

protected:

    volatile hkUint32 m_value;
};

#else

#include <Common/Base/Thread/Semaphore/hkSemaphore.h>

// fallback for non Cell platforms, or non threaded Cell builds
typedef hkSemaphore hkSemaphoreBusyWait;

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
