// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO APOLLO_ARM APOLLO_X86 METRO_X86 METRO_X64 METRO_ARM UWP OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Semaphore/hkSemaphore.h>

#if defined(HK_PLATFORM_SIM)
#include <Common/Base/Spu/Simulator/hkSpuSimulator.h>
#endif

#ifdef HK_PLATFORM_WIN32
#   include <Common/Base/Fwd/hkwindows.h>
#endif

#if defined(HK_PLATFORM_SIM)

        hkSemaphore::hkSemaphore( int initialCount, int maxCount, int numSpinIterations )
        {
            m_semaphore = CreateSemaphore(
                    NULL,           // default security attributes
                    initialCount,   // initial count
                    maxCount,       // maximum count
                    NULL);          // unnamed semaphore
        }

        hkSemaphore::~hkSemaphore()
        {
            CloseHandle( m_semaphore );
        }

        void hkSemaphore::acquire()
        {
            HK_ON_DEBUG(DWORD dwWaitResult =) WaitForSingleObject( m_semaphore, INFINITE );          // zero-second time-out interval
            HK_ASSERT_NO_MSG(0xf0324354, dwWaitResult == WAIT_OBJECT_0);
        }

        void hkSemaphore::release(int count)
        {
            HK_ON_DEBUG(BOOL success =) ReleaseSemaphore(
                m_semaphore,    // handle to semaphore
                count,          // increase count by 'count'
                NULL);          // not interested in previous count

            HK_ASSERT(0xad7633dd, success, "hkSemaphore::release() failed!!");
        }

        hkResult hkSemaphore::tryAcquire()
        {
            DWORD dwWaitResult =
                WaitForSingleObject(m_semaphore, 0);          // zero-second time-out interval
            HK_ASSERT_NO_MSG(0xf0324355, (dwWaitResult == WAIT_OBJECT_0) || (dwWaitResult == WAIT_TIMEOUT));

            if (dwWaitResult == WAIT_OBJECT_0)
            {
                return HK_SUCCESS;
            }

            return HK_FAILURE;
        }

        hkResult hkSemaphore::tryRelease(int count)
        {
            bool ret = ReleaseSemaphore(
                m_semaphore,    // handle to semaphore
                count,          // increase count by 'count'
                NULL);          // not interested in previous count

            if (!ret)
            {
                return HK_FAILURE;
            }

            return HK_SUCCESS;
        }

        // static function
        void hkSemaphore::acquire(_Inout_ hkSemaphore* semaphoreOnPpu)
    {
        semaphoreOnPpu->acquire();
    }

        // static function
    void hkSemaphore::release(_Inout_ hkSemaphore* semaphoreOnPpu, int count)
    {
        semaphoreOnPpu->release(count);
    }

#else // #elif !defined(HK_PLATFORM_SIM)

    hkSemaphore::hkSemaphore( int initialCount, int maxCount, int numSpinIterations )
    {
    #if !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)
        m_semaphore = CreateSemaphore(
            NULL,           // default security attributes
            initialCount,   // initial count
            maxCount,       // maximum count
            NULL);          // unnamed semaphore
    #else
        m_semaphore = CreateSemaphoreExW(
            NULL,           // default security attributes
            initialCount,   // initial count
            maxCount,       // maximum count
            NULL, // unnamed (wchar_t here) semaphore
            0, //flags
            STANDARD_RIGHTS_ALL | SEMAPHORE_MODIFY_STATE  //desiredAccess
            );
    #endif
    }

    hkSemaphore::~hkSemaphore()
    {
        CloseHandle( m_semaphore );
    }

    void hkSemaphore::acquire()
    {
        HK_ON_DEBUG( DWORD dwWaitResult = )
    #if !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)
        WaitForSingleObject( m_semaphore, INFINITE );          // zero-second time-out interval
    #else
        WaitForSingleObjectEx( m_semaphore, INFINITE, FALSE );
    #endif
        HK_ASSERT_NO_MSG(0xf0324354, dwWaitResult == WAIT_OBJECT_0);
    }

    hkResult hkSemaphore::tryAcquire()
    {
        DWORD dwWaitResult =
#if !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)
            WaitForSingleObject(m_semaphore, 0);          // zero-second time-out interval
#else
            WaitForSingleObjectEx(m_semaphore, 0, FALSE);
#endif
        HK_ASSERT_NO_MSG(0xf0324355, (dwWaitResult == WAIT_OBJECT_0) || (dwWaitResult == WAIT_TIMEOUT));

        if (dwWaitResult == WAIT_OBJECT_0)
        {
            return HK_SUCCESS;
        }

        return HK_FAILURE;
    }

    void hkSemaphore::release(int count)
    {
        ReleaseSemaphore(
                m_semaphore,    // handle to semaphore
                count,          // increase count by 'count'
                NULL);          // not interested in previous count
    }

    hkResult hkSemaphore::tryRelease(int count)
    {
        bool ret = ReleaseSemaphore(
            m_semaphore,    // handle to semaphore
            count,          // increase count by 'count'
            NULL);          // not interested in previous count

        if (!ret)
        {
            return HK_FAILURE;
        }

        return HK_SUCCESS;
    }

        // static function
    void hkSemaphore::acquire(_Inout_ hkSemaphore* semaphore)
    {
        semaphore->acquire();
    }

        // static function
    void hkSemaphore::release(_Inout_ hkSemaphore* semaphore, int count)
    {
        semaphore->release(count);
    }

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
