// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : NX32 NX64
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Semaphore/hkSemaphore.h>
#include <Common/Base/Thread/Semaphore/hkSemaphoreBusyWait.h>
#include <Common/Base/Fwd/hkcstdio.h>

#include <nn/os.h>

#if (HK_CONFIG_THREAD==HK_CONFIG_MULTI_THREADED)

hkSemaphore::hkSemaphore( int initialCount, int maxCount, int numSpinIterations )
{
    if ((maxCount < 1) || (initialCount > maxCount))
    {
        HK_BREAKPOINT(0);
        return;
    }

    nn::os::InitializeSemaphore(&m_semaphore, initialCount, maxCount);
}

hkSemaphore::~hkSemaphore()
{
    nn::os::FinalizeSemaphore(&m_semaphore);
}

void hkSemaphore::acquire()
{
    nn::os::AcquireSemaphore(&m_semaphore);
}

hkResult hkSemaphore::tryAcquire()
{
    return nn::os::TryAcquireSemaphore(&m_semaphore) ? HK_SUCCESS : HK_FAILURE;
}

void hkSemaphore::release(int count)
{
    nn::os::ReleaseSemaphore(&m_semaphore, count);
}

hkResult hkSemaphore::tryRelease(int count)
{
    //int c = nn::os::GetCurrentSemaphoreCount(&m_semaphore);
    release(count);
    return HK_SUCCESS;
}

#else // Empty

hkSemaphore::hkSemaphore( int initialCount, int maxCount )
{
    HK_WARN(0xf9178faf, "hkSemaphore being used in a single threaded environment. It will have no effect.");
}

hkSemaphore::~hkSemaphore()
{
}

void hkSemaphore::acquire()
{
}

void hkSemaphore::release(int count)
{
}

hkResult hkSemaphore::tryAcquire()
{
    return HK_SUCCESS;
}

hkResult hkSemaphore::tryRelease(int count)
{
    return HK_SUCCESS;
}

#endif

// static function
void hkSemaphore::acquire(hkSemaphore* semaphore)
{
    semaphore->acquire();
}

// static function
void hkSemaphore::release(hkSemaphore* semaphore, int count)
{
    semaphore->release(count);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
