// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Thread/Semaphore/hkSemaphore.h>

    // Readers-Write lock, allows multiple readers but a single writer.
class HK_EXPORT_COMMON hkReadersWriterLock
{
    public:
        HK_DECLARE_CLASS(hkReadersWriterLock, New, NonCopyable);

        hkReadersWriterLock();
        ~hkReadersWriterLock();

        void enterRO();
        void leaveRO();

        void enterRW();
        void leaveRW();

    private:

        hkCriticalSection m_mutexReadIn;
        hkCriticalSection m_mutexReadOut;
        hkSemaphore m_semWriteWake;
        int m_countReadIn;
        int m_countReadOut;
        bool m_writerWaiting;
};

    // Automatically (RAII) acquire/release a reading lock shared with other readers.
class hkReadLock
{
    public:
        HK_DECLARE_CLASS(hkReadLock, NonCopyable, NoNew);

        HK_ALWAYS_INLINE hkReadLock(hkReadersWriterLock& readersWriterLock)
            : m_lock(readersWriterLock) { m_lock.enterRO(); }

        HK_ALWAYS_INLINE ~hkReadLock() { m_lock.leaveRO(); }

    private:
        hkReadersWriterLock& m_lock;
};

    // Automatically (RAII) acquire/release an exclusive writing lock.
class hkWriteLock
{
    public:
        HK_DECLARE_CLASS(hkWriteLock, NonCopyable, NoNew);

        HK_ALWAYS_INLINE hkWriteLock(hkReadersWriterLock& readersWriterLock)
            : m_lock(readersWriterLock) { m_lock.enterRW(); }

        HK_ALWAYS_INLINE ~hkWriteLock() { m_lock.leaveRW(); }

    private:
        hkReadersWriterLock& m_lock;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
