// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/ReadersWriterLock/hkReadersWriterLock.h>

// See "Faster Fair Solution for the Reader-Writer Problem"
// By Vlad Popov and Oleg Mazonka
// http://arxiv.org/ftp/arxiv/papers/1309/1309.4507.pdf

hkReadersWriterLock::hkReadersWriterLock()
: m_mutexReadIn(1000)
, m_mutexReadOut(1000)
, m_semWriteWake(0,1)
, m_countReadIn(0)
, m_countReadOut(0)
, m_writerWaiting(0)
{
}

hkReadersWriterLock::~hkReadersWriterLock()
{
}

void hkReadersWriterLock::enterRO()
{
    m_mutexReadIn.enter();
    m_countReadIn += 1;
    m_mutexReadIn.leave();
}

void hkReadersWriterLock::leaveRO()
{
    m_mutexReadOut.enter();
    m_countReadOut += 1;
    if( m_writerWaiting && m_countReadIn==m_countReadOut) // writer waiting and I'm the last
    {
        m_semWriteWake.release();
    }
    m_mutexReadOut.leave();
}

void hkReadersWriterLock::enterRW()
{
    m_mutexReadIn.enter(); // block new readers & writers
    m_mutexReadOut.enter();
    if( m_countReadIn == m_countReadOut ) // no readers, proceed
    {
        m_mutexReadOut.leave();
    }
    else // wait for readers to finish
    {
        m_writerWaiting = true;
        m_mutexReadOut.leave();
        m_semWriteWake.acquire();
        // normally m_writerWaiting is protected by m_mutextReadOut
        // however when we get here, we have exclusive access.
        // Nobody else can read this flag until after we leaveRW
        // (which must contain a memory fence) so it works even
        // on weakly ordered architectures
        m_writerWaiting = false;
    }
}

void hkReadersWriterLock::leaveRW()
{
    m_mutexReadIn.leave(); // allow readers/writer to enter again
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
