// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/JobQueue/hkJobQueue.h>

class hkDefaultTaskQueue;
struct hkTimerData;


/// Interface for managing a set of worker threads.
class HK_EXPORT_COMMON hkThreadPool : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkThreadPool, New, ReflectIdentity);

        virtual ~hkThreadPool() {}

        /// Begin processing jobs in the queue using the thread pool and return immediately (non-blocking call).
        virtual void processJobQueue(_Inout_ hkJobQueue* jobQueue, hkJobType firstJobType = HK_JOB_TYPE_MAX) = 0;

        /// Begin processing tasks in the queue using the thread pool and return immediately (non-blocking call).
        virtual void processTaskQueue(_Inout_ hkDefaultTaskQueue* taskQueue ) = 0;

        /// Return true if any of the worker threads is currently processing a work load.
        virtual bool isProcessing() const { return ( getProcessingTaskQueue() != HK_NULL ) || ( getProcessingJobQueue() != HK_NULL ); }

        /// Return the job queue the thread pool is currently processing or HK_NULL if
        /// no queue is currently being processed.
        virtual _Ret_maybenull_ hkJobQueue* getProcessingJobQueue() const = 0;

        /// Return the task queue the thread pool is currently processing or HK_NULL if
        /// no queue is currently being processed.
        virtual _Ret_maybenull_ hkDefaultTaskQueue* getProcessingTaskQueue() const = 0;

        /// Wait until all worker threads have finished processing the last work load.
        virtual void waitForCompletion() = 0;

        /// Get the number of threads in use.
        virtual int getNumThreads() const = 0;

        /// Set the number of threads in use.
        virtual void setNumThreads( int numThreads ) = 0;

        /// Get the timer data collected while processing.
        virtual void appendTimerData( hkArray<hkTimerData>& timerDataOut ) = 0;

        /// Clear the timer data. This must be done every frame or the timers will overrun.
        virtual void clearTimerData() = 0;

        /// Cause threads to garbage collect their memory immediately before signaling completion.
        /// Call this method before the processX() ones. Note this only applies to the next completion, it is reset to
        /// false when waitForCompletion() returns. This allows a subsequent garbage collection of the main heap
        /// (hkMemorySystem::garbageCollect) to recover more memory. This operation should only be called when needed
        /// since repopulating the thread local caches can be expensive.
        virtual void gcThreadMemoryOnNextCompletion() = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
