// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HKBASE_HK_CRITICAL_SECTION_H
#define HKBASE_HK_CRITICAL_SECTION_H

#include <Common/Base/Config/hkConfigThread.h>
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Thread/Atomic/hkAtomicPrimitives.h>

// Set this define if you want a timer begin and timer end call
// if a thread has to wait for a critical section
// You also have to call hkCriticalSection::setTimersEnabled()
//#define HK_TIME_CRITICAL_SECTION_LOCKS

// Set this if you want to use our WIN32 critical section
#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)
//# define HK_USE_FAST_WIN32_CRITICAL_SECTION
#endif


#if HK_CONFIG_THREAD == HK_CONFIG_MULTI_THREADED
#   if defined(HK_PLATFORM_WIN32)
#       if !defined(HK_USE_FAST_WIN32_CRITICAL_SECTION)
        extern "C"
        {
            struct _RTL_CRITICAL_SECTION;
            struct _RTL_CRITICAL_SECTION_DEBUG;
            typedef _RTL_CRITICAL_SECTION_DEBUG RTL_CRITICAL_SECTION_DEBUG, *PRTL_CRITICAL_SECTION_DEBUG;
            typedef struct _RTL_CRITICAL_SECTION RTL_CRITICAL_SECTION, *PRTL_CRITICAL_SECTION;
            typedef RTL_CRITICAL_SECTION CRITICAL_SECTION;
            typedef PRTL_CRITICAL_SECTION PCRITICAL_SECTION;
            typedef PRTL_CRITICAL_SECTION LPCRITICAL_SECTION;
            __declspec(dllimport) void __stdcall DeleteCriticalSection(_Inout_ LPCRITICAL_SECTION lpCriticalSection);
            __declspec(dllimport) void __stdcall EnterCriticalSection(_Inout_ LPCRITICAL_SECTION lpCriticalSection);
            __declspec(dllimport) void __stdcall LeaveCriticalSection(_Inout_ LPCRITICAL_SECTION lpCriticalSection);
        }
        #endif
#   elif defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_LINUX) || \
          defined(HK_PLATFORM_LRBXENSIM) || defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN) || defined(HK_PLATFORM_PS4)
#       include <pthread.h>
#   elif defined(HK_PLATFORM_WIIU)
#       include <cafe/os.h>
#   elif defined(HK_PLATFORM_LRBSIM)
#       include <common/winpthread.h>
#   elif defined(HK_PLATFORM_NX)
#       include <nn/os/os_Mutex.h>
#   endif
#endif




    /// Critical section wrapper. This can be used to guard access
    /// to shared data structures between threads.
    /// Note that critical sections are fast but have serious drawbacks.
    /// Check windows help for details.
    /// Note that including this file means including a system file, such as windows.h,
    /// which makes compile time significantly slower.
class HK_EXPORT_COMMON hkCriticalSection
{
    public:
        HK_DECLARE_CLASS(hkCriticalSection, New, NonCopyable);

            /// Init a critical section with spin count.
            /// Read MSDN help of InitializeCriticalSectionAndSpinCount for details.
            ///
            /// In short: positive spinCount value results in threads doing busy waiting and is good
            /// when you know that the critical section will only be locked for a short period of time.
            /// zero value causes the thread to immediately go back to the system when waiting.
        hkCriticalSection( int spinCount = 0 );

            /// Quit a critical section
        ~hkCriticalSection();

            /// Lock a critical section
        void enter();

            /// Unlock a critical section
        void leave();

            /// Tell the critical section to time blocking locks. HK_TIME_CRITICAL_SECTION_LOCKS must be
            /// defined at compile time for this flag to have any effect
        static void HK_CALL setTimersEnabled();

            /// Stop timing blocking locks
        static void HK_CALL setTimersDisabled();

    public:

#if HK_CONFIG_THREAD == HK_CONFIG_MULTI_THREADED
#   if defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN) || defined(HK_PLATFORM_PS4)

        /// OS mutex
        pthread_mutex_t m_mutex;

        /// Number of times that will try to lock the mutex before blocking
        int m_spinCount;

#   elif defined(HK_PLATFORM_WIIU)

#   elif defined(HK_PLATFORM_NX)
        nn::os::Mutex m_mutex;

//# elif defined(HK_PLATFORM_ANDROID)
//      hkInt32 m_recursiveLockCount;
//      volatile hkUint32 m_currentThread;
#   elif defined(HK_USE_FAST_WIN32_CRITICAL_SECTION)
        void unlockImpl();                                  ///< implementation of unlock if a cheap unlock fails

        // Declare all variables volatile, so that the compiler won't try to optimize something important.
        volatile void*    m_semaphoreHandle;                ///< the operating system semaphore, allocated on demand
        volatile hkUint32 m_lockingThread;                  ///< the thead which locked this critical section
        volatile hkUint32 m_numThreadsWaitingOnSemaphore;   ///< number of threads waiting on semaphore, this is allowed to become negative
        volatile hkUint16 m_spinCount;                      ///< the number of iterations before falling back to the system semaphore
        volatile hkUint16 m_numRecursiveLocks;              ///< the number of recursive enters

#   else // other threaded platforms: (mainly win32)

        struct CRITICAL_SECTION
        {
            PRTL_CRITICAL_SECTION* DebugInfo;
            hkInt32 LockCount;
            hkInt32 RecursionCount;
            void* OwningThread;        // from the thread's ClientId->UniqueThread
            void* LockSemaphore;
            hkUlong SpinCount;        // force size on 64-bit systems when packed
            ::CRITICAL_SECTION* cast() { return reinterpret_cast< ::CRITICAL_SECTION* >(this); }
        };
        CRITICAL_SECTION  m_section;
#   endif
#endif
};

// move to static member when compiler support
#if HK_CONFIG_THREAD == HK_CONFIG_MULTI_THREADED && defined(HK_TIME_CRITICAL_SECTION_LOCKS)
    extern HK_EXPORT_COMMON HK_THREAD_LOCAL( int ) hkCriticalSection__m_timeLocks;
#endif

// include the inl before the hkCriticalSectionLock def so
// that gcc can inline the enter and leave properly
#if HK_CONFIG_THREAD != HK_CONFIG_MULTI_THREADED
#       include <Common/Base/Thread/CriticalSection/Empty/hkEmptyCriticalSection.inl>
#else // HK_CONFIG_THREAD == HK_CONFIG_MULTI_THREADED
#   include <Common/Base/Thread/Thread/hkThread.h>
#   define HK_INVALID_THREAD_ID (hkUint64(-1))

#   if defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS)
#       include <Common/Base/Thread/CriticalSection/Mac/hkMacCriticalSection.inl>
#   elif defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN) || defined(HK_PLATFORM_PS4)
#       include <Common/Base/Thread/Thread/Posix/hkPosixCheck.h>
#       include <Common/Base/Thread/CriticalSection/Posix/hkPosixCriticalSection.inl>
#   elif defined(HK_PLATFORM_NX)
#       include <Common/Base/Thread/CriticalSection/Nx/hkNxCriticalSection.inl>
#   elif defined(HK_PLATFORM_WIIU)
#       include <Common/Base/Thread/CriticalSection/WiiU/hkWiiuCriticalSection.inl>
//# elif defined(HK_PLATFORM_ANDROID)
//#     include <Common/Base/Thread/CriticalSection/Arm/hkArmCriticalSection.inl>
#   else
#       include <Common/Base/Thread/CriticalSection/Win32/hkWin32CriticalSection.inl>
#   endif
#endif

/// Helper class which locks a critical section as long is this object exists.
class HK_EXPORT_COMMON hkCriticalSectionLock
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE_CLASS, hkCriticalSectionLock);

        /// Create a lock by entering a critical section.
        HK_INLINE hkCriticalSectionLock(_Inout_ hkCriticalSection* section) { m_section = section; section->enter(); }

        /// Destructor leaves the critical section
        HK_INLINE ~hkCriticalSectionLock()  {   m_section->leave(); }

        hkCriticalSection* m_section;
};

#endif // HKBASE_HK_CRITICAL_SECTION_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
