// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO METRO_X86 METRO_X64 METRO_ARM APOLLO_ARM APOLLO_X86 UWP OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

    //
    // Win32
    //
#if defined(HK_USE_FAST_WIN32_CRITICAL_SECTION)
    HK_INLINE void hkCriticalSection::leave()
    {
        if (--m_numRecursiveLocks == 0)
        {
            hkAtomic::readWriteBarrier(); // a write barrier would do the trick, but not available
            m_lockingThread = 0;
            hkAtomic::readWriteBarrier(); // The CS is released.
            if (m_numThreadsWaitingOnSemaphore > 0) // See comment at the end of the .cpp file
            {
                unlockImpl();
            }
        }
    }
#else

#   ifndef HK_TIME_CRITICAL_SECTION_LOCKS
    HK_INLINE void hkCriticalSection::enter()
    {
        EnterCriticalSection(m_section.cast());
    }
#   endif   // HK_TIME_CRITICAL_SECTION_LOCKS

    HK_INLINE void hkCriticalSection::leave()
    {
        LeaveCriticalSection(m_section.cast());
    }
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
