// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE _Ret_maybenull_ hkTaskQueue* hkConcurrency::getTaskQueue() const
{
    return m_taskQueue;
}

HK_INLINE hkTaskQueue* hkConcurrency::getTaskQueueIfMultithreaded() const
{
    return m_singleThreaded ? HK_NULL : m_taskQueue;
}

template <typename CONTAINER>
HK_INLINE void hkConcurrency::awaitAll( CONTAINER& asyncHandles )
{
    for ( AsyncHandle& handle : asyncHandles )
    {
        hkConcurrency::await( handle );
    }
}

namespace hkConcurrencyInternals
{

    template <typename FUNCTION>
    class BatchProcessor : public hkTask
    {
    public:
        HK_INLINE BatchProcessor( const FUNCTION& function, int numThreads, int numItems, int minBatchSize ) : m_function( function )
        {
            m_iter.initThreadInfo( numThreads, numItems );
            m_minBatchSize = minBatchSize;
        }

        virtual void process( const hkTask::Input& input )
        {
            hkAtomicIntIterator iter( &m_iter, input.m_multiplicityIndex );
            iter.m_minBatchSize = m_minBatchSize;
            iter.m_batchSize = hkMath::max2( iter.m_batchSize, m_minBatchSize );
            for ( hkUint32 i; iter.getItem( &i ).isSuccess(); )
            {
                m_function( i );
            }
        }

        const FUNCTION m_function;
        hkIntegerDistributor m_iter;
        hkUint32 m_minBatchSize;
    };

    template <typename FUNCTION>
    struct BatchProcessorEx : public hkTask
    {
        HK_INLINE BatchProcessorEx( const FUNCTION& function, hkIntegerDistributor* dis, int batchSize ) : m_function( function ) { m_distributor = dis; m_minBatchSize = batchSize; }

        virtual void process( const hkTask::Input& input )
        {
            hkConcurrency::Iterator iter( m_distributor, input.m_multiplicityIndex );
            iter.m_minBatchSize = m_minBatchSize; iter.m_batchSize = m_minBatchSize;
            m_function( iter );
        }

        hkIntegerDistributor* m_distributor;
        const FUNCTION m_function;
        hkUint32 m_minBatchSize;
    };
};


template <typename FUNCTION>
HK_INLINE void hkConcurrency::parallelFor( int numItems, bool singleThreaded, const FUNCTION& function )
{
    int minBatchSize = 0;
    if ( singleThreaded || hkUint32( numItems ) <= 1 + hkUint32( minBatchSize * 4 ) )
    {
    SINGLE_THREADED:
        hkConcurrencyInternals::BatchProcessor<FUNCTION> batchProcessor( function, 1, numItems, numItems );
        for ( int i = 0; i < numItems; ++i ) batchProcessor.m_function( i );
    }
    else
    {
        hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
        if ( !taskQueue )
        {
            goto SINGLE_THREADED;
        }
        int numThreads = 1 + taskQueue->getNumThreadsHint();
        hkConcurrencyInternals::BatchProcessor<FUNCTION> batchProcessor( function, numThreads, numItems, minBatchSize );
        numItems = hkMath::min2( numThreads, numItems ); // multiplicity is limited to 16 bit !!!!
        hkTaskQueue::Handle handle = taskQueue->addAndSubmitTask( &batchProcessor, numItems, hkTask::MultiplicityMode::ABORT_ON_FIRST_FINISHED_TASK );
        taskQueue->processAndFree( handle );
    }
}

template <typename FUNCTION>
HK_INLINE void hkConcurrency::parallelForEx( int numItems, int minBatchSize, bool singleThreaded, const FUNCTION& function )
{
    if ( singleThreaded || ( hkUint32( numItems ) <= 1 + hkUint32( minBatchSize * 4 ) ) )
    {
    SINGLE_THREADED:
        hkIntegerDistributor intDistributor; intDistributor.initThreadInfo( 1, numItems );
        hkConcurrency::Iterator iter( &intDistributor, 0 );
        function( iter );
    }
    else
    {
        hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
        if ( !taskQueue )
        {
            goto SINGLE_THREADED;
        }
        int numThreads = 1 + taskQueue->getNumThreadsHint();

        hkIntegerDistributor intDistributor; intDistributor.initThreadInfo( numThreads, numItems );

        hkConcurrencyInternals::BatchProcessorEx<FUNCTION> batchProcessor( function, &intDistributor, minBatchSize );

        numThreads = hkMath::min2( numThreads, numItems ); // multiplicity is limited to 16 bit !!!!
        hkTaskQueue::Handle handle = taskQueue->addAndSubmitTask( &batchProcessor, numThreads, hkTask::MultiplicityMode::ABORT_ON_FIRST_FINISHED_TASK );
        taskQueue->processAndFree( handle );
    }
}











namespace hkConcurrencyInternals
{
    struct AsyncTask : hkTask
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, AsyncTask );
        virtual ~AsyncTask() {}
        virtual void process( const hkTask::Input& input ) HK_OVERRIDE { execute(); delete this; }
        virtual void execute() = 0;
    };

    template <typename FUNCTION>
    struct AsyncTaskT0 : AsyncTask
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, AsyncTaskT0 );
        AsyncTaskT0( const FUNCTION& function ) : m_function( function ) {}
        virtual void execute() HK_OVERRIDE { m_function(); }
        const FUNCTION m_function;
    };

    template <typename FUNCTION, typename A0>
    struct AsyncTaskT1 : AsyncTask
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, AsyncTaskT1 );
        AsyncTaskT1( const FUNCTION& function, const A0& a0 ) : m_function( function ), m_a0( a0 ) {}
        virtual void execute() HK_OVERRIDE { m_function( m_a0 ); }
        const FUNCTION m_function;
        const A0 m_a0;
    };

    template <typename FUNCTION, typename A0, typename A1>
    struct AsyncTaskT2 : AsyncTask
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, AsyncTaskT2 );
        AsyncTaskT2( const FUNCTION& function, const A0& a0, const A1& a1 ) : m_function( function ), m_a0( a0 ), m_a1( a1 ) {}
        virtual void execute() HK_OVERRIDE { m_function( m_a0, m_a1 ); }
        const FUNCTION m_function;
        const A0 m_a0;
        const A1 m_a1;
    };

    template <typename FUNCTION, typename A0, typename A1, typename A2>
    struct AsyncTaskT3 : AsyncTask
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, AsyncTaskT3 );
        AsyncTaskT3( const FUNCTION& function, const A0& a0, const A1& a1, const A2& a2 ) : m_function( function ), m_a0( a0 ), m_a1( a1 ), m_a2( a2 ) {}
        virtual void execute() HK_OVERRIDE { m_function( m_a0, m_a1, m_a2 ); }
        const FUNCTION m_function;
        const A0 m_a0;
        const A1 m_a1;
        const A2 m_a2;
    };

    template <typename FUNCTION, typename A0, typename A1, typename A2, typename A3>
    struct AsyncTaskT4 : AsyncTask
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, AsyncTaskT4 );
        AsyncTaskT4( const FUNCTION& function, const A0& a0, const A1& a1, const A2& a2, const A3& a3 ) : m_function( function ), m_a0( a0 ), m_a1( a1 ), m_a2( a2 ), m_a3( a3 ) {}
        virtual void execute() HK_OVERRIDE { m_function( m_a0, m_a1, m_a2, m_a3 ); }
        const FUNCTION m_function;
        const A0 m_a0;
        const A1 m_a1;
        const A2 m_a2;
        const A3 m_a3;
    };
}



template <typename FUNCTION>
hkConcurrency::AsyncHandle hkConcurrency::async( const FUNCTION& function )
{
    hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
    if ( taskQueue )
    {
        // Multi-threaded.
        hkConcurrencyInternals::AsyncTask* task = new hkConcurrencyInternals::AsyncTaskT0<FUNCTION>( function );
        return taskQueue->addAndSubmitTask( task );
    }
    else
    {
        // Single-threaded.
        function();
        return HK_NULL;
    }
}

template <typename FUNCTION, typename A0>
hkConcurrency::AsyncHandle hkConcurrency::async( const FUNCTION& function, const A0& a0 )
{
    hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
    if ( taskQueue )
    {
        // Multi-threaded.
        hkConcurrencyInternals::AsyncTask* task = new hkConcurrencyInternals::AsyncTaskT1<FUNCTION, A0>( function, a0 );
        return taskQueue->addAndSubmitTask( task );
    }
    else
    {
        // Single-threaded.
        function( a0 );
        return HK_NULL;
    }
}

template <typename FUNCTION, typename A0, typename A1>
hkConcurrency::AsyncHandle hkConcurrency::async( const FUNCTION& function, const A0& a0, const A1& a1 )
{
    hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
    if ( taskQueue )
    {
        // Multi-threaded.
        hkConcurrencyInternals::AsyncTask* task = new hkConcurrencyInternals::AsyncTaskT2<FUNCTION, A0, A1>( function, a0, a1 );
        return taskQueue->addAndSubmitTask( task );
    }
    else
    {
        // Single-threaded.
        function( a0, a1 );
        return HK_NULL;
    }
}

template <typename FUNCTION, typename A0, typename A1, typename A2>
hkConcurrency::AsyncHandle hkConcurrency::async( const FUNCTION& function, const A0& a0, const A1& a1, const A2& a2 )
{
    hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
    if ( taskQueue )
    {
        // Multi-threaded.
        hkConcurrencyInternals::AsyncTask* task = new hkConcurrencyInternals::AsyncTaskT3<FUNCTION, A0, A1, A2>( function, a0, a1, a2 );
        return taskQueue->addAndSubmitTask( task );
    }
    else
    {
        // Single-threaded.
        function( a0, a1, a2 );
        return HK_NULL;
    }
}

template <typename FUNCTION, typename A0, typename A1, typename A2, typename A3>
hkConcurrency::AsyncHandle hkConcurrency::async( const FUNCTION& function, const A0& a0, const A1& a1, const A2& a2, const A3& a3 )
{
    hkTaskQueue* taskQueue = getInstance().getTaskQueueIfMultithreaded();
    if ( taskQueue )
    {
        // Multi-threaded.
        hkConcurrencyInternals::AsyncTask* task = new hkConcurrencyInternals::AsyncTaskT4<FUNCTION, A0, A1, A2, A3>( function, a0, a1, a2, a3 );
        return taskQueue->addAndSubmitTask( task );
    }
    else
    {
        // Single-threaded.
        function( a0, a1, a2, a3 );
        return HK_NULL;
    }
}

#undef HKCONCURRENCY_START_AND_RETURN_ASYNC

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
