// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Concurrency/hkConcurrency.h>
#include <Common/Base/Object/hkSingleton.h>

HK_SINGLETON_IMPLEMENTATION( hkConcurrency );

hkConcurrency::hkConcurrency()
    : m_taskQueue( HK_NULL )
    , m_singleThreaded( false )
{
}

void hkConcurrency::setTaskQueue(_In_opt_ hkTaskQueue* taskQueue)
{
    // Stay single-threaded if HK_CONFIG_THREAD is not set to HK_CONFIG_MULTI_THREADED
    #if HK_CONFIG_THREAD == HK_CONFIG_MULTI_THREADED
    m_taskQueue = taskQueue;
    #endif
}

void hkConcurrency::setSingleThreaded( bool singleThreaded )
{
    m_singleThreaded = singleThreaded;
}

bool hkConcurrency::isSingleThreaded() const
{
    return m_singleThreaded;
}

bool hkConcurrency::await( AsyncHandle& asyncHandle, bool blocking )
{
    if ( asyncHandle )
    {
        hkTaskQueue* taskQueue = getInstance().getTaskQueue();
        if ( !blocking && !taskQueue->isFinished( asyncHandle ) ) return false;
        taskQueue->processAndFree( asyncHandle );
        asyncHandle = HK_NULL;
    }
    return true;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
