// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkResult hkIntegerDistributor::getItem( int currentThreadId, _Out_ hkUint32* indexOut )
{
    currentThreadId = currentThreadId + 1;
    int queueIndex = m_threadData[currentThreadId].m_lastSuccesfulQueue;
    Queue& counter = m_queues[queueIndex];

    // the next 2 lines must be atomic
    hkUint64 counterAndMax = hkAtomic::exchangeAdd64( &counter.m_counterAndMax, 1 );
    hkUint32 index = counterOf(counterAndMax);
    if ( index < maxValueOf(counterAndMax) )
    {
        indexOut[0] = index;
        return HK_SUCCESS;
    }
    // now we need to do work stealing
    return refillLocalCounterAndGetItem( currentThreadId, indexOut );
}


HK_INLINE hkAtomicIntIterator::hkAtomicIntIterator(_In_ hkIntegerDistributor* distributor, int threadId)
{
    m_current = m_max = 0;
        m_threadId = threadId;
    m_integers = distributor;
    m_batchSize = 1;
    m_minBatchSize = 1;
}

hkResult hkAtomicIntIterator::getItem( _Out_ hkUint32* indexOut )
{
    if (m_current >= m_max)
    {
        hkResult res = m_integers->getItems(m_threadId, &m_batchSize, &m_current, &m_max);
        if ( res.isFailure())
        {
            return HK_FAILURE;
        }
        if ( m_batchSize < m_minBatchSize)
        {
            m_batchSize = m_minBatchSize;
        }
    }
    *indexOut = m_current++;
    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
