// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO APOLLO_ARM APOLLO_X86 METRO_X86 METRO_X64 METRO_ARM UWP_X86 UWP_X64 UWP_ARM NX32_WIN NX64_WIN
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//#include <intrin.h>

#ifndef __INTRIN_H_
long _InterlockedCompareExchange8(char volatile * _Destination, char _Exchange, char _Comparand);
long _InterlockedCompareExchange16(short volatile * _Destination, short _Exchange, short _Comparand);
long _InterlockedCompareExchange(long volatile * _Destination, long _Exchange, long _Comparand);
__int64 _InterlockedCompareExchange64(__int64 volatile * _Destination, __int64 _Exchange, __int64 _Comparand);
long _InterlockedExchange8(long volatile * _Target, long _Value);
long _InterlockedExchange16(long volatile * _Target, long _Value);
long _InterlockedExchange(long volatile * _Target, long _Value);

#ifdef HK_ARCH_X64
__int64 _InterlockedExchange64(__int64 volatile * _Target, __int64 _Value);
#endif
#endif

#pragma intrinsic(_InterlockedExchangeAdd)
#pragma intrinsic(_InterlockedCompareExchange8)
#pragma intrinsic(_InterlockedCompareExchange16)
#pragma intrinsic(_InterlockedCompareExchange)
#pragma intrinsic(_InterlockedCompareExchange64)
#pragma intrinsic(_InterlockedExchange8)
#pragma intrinsic(_InterlockedExchange16)
#pragma intrinsic(_InterlockedExchange)
#ifdef HK_ARCH_X64
#   pragma intrinsic(__faststorefence)
#   pragma intrinsic(_InterlockedExchangeAdd64)
#   pragma intrinsic(_InterlockedExchange64)
#endif

#ifdef HK_ARCH_X64
#define HK_ATOMIC_SUPPORT_64BIT
#endif

#define HK_NATIVE_ATOMIC_ADD

namespace hkAtomic
{
    namespace Detail
    {
        template <int size>
        HK_INLINE bool HK_CALL compareAndSwap(typename Storage<size>::Type* address, typename Storage<size>::Type* curValue, typename Storage<size>::Type newValue)
        {
            typename Storage<size>::Type curValueLocal = *curValue;
            typename Storage<size>::Type oldVal = compareAndSwapVal<size>(address, curValueLocal, newValue);
            if(oldVal == curValueLocal)
            {
                return true;
            }
            else
            {
                *curValue = oldVal;
                return false;
            }
        }

        template <>
        HK_INLINE bool HK_CALL compareAndSwapBool<1>(hkUint8* address, hkUint8 oldValue, hkUint8 newValue)
        {
            return _InterlockedCompareExchange8((char*)address, (char)newValue, (char)oldValue) == (char)oldValue;
        }

        template <>
        HK_INLINE hkUint8 HK_CALL compareAndSwapVal<1>(hkUint8* address, hkUint8 oldValue, hkUint8 newValue)
        {
            return (hkUint8)_InterlockedCompareExchange8((char*)address, (char)newValue, (char)oldValue);
        }

        template <>
        HK_INLINE bool HK_CALL compareAndSwapBool<2>(hkUint16* address, hkUint16 oldValue, hkUint16 newValue)
        {
            return _InterlockedCompareExchange16((short*)address, (short)newValue, (short)oldValue) == (short)oldValue;
        }

        template <>
        HK_INLINE hkUint16 HK_CALL compareAndSwapVal<2>(hkUint16* address, hkUint16 oldValue, hkUint16 newValue)
        {
            return (hkUint16)_InterlockedCompareExchange16((short*)address, (short)newValue, (short)oldValue);
        }

        template <>
        HK_INLINE bool HK_CALL compareAndSwapBool<4>(hkUint32* address, hkUint32 oldValue, hkUint32 newValue)
        {
            return _InterlockedCompareExchange((long*)address, (long)newValue, (long)oldValue) == (long)oldValue;
        }

        template <>
        HK_INLINE hkUint32 HK_CALL compareAndSwapVal<4>(hkUint32* address, hkUint32 oldValue, hkUint32 newValue)
        {
            return (hkUint32)_InterlockedCompareExchange((long*)address, (long)newValue, (long)oldValue);
        }

        template <>
        HK_INLINE bool HK_CALL compareAndSwapBool<8>(hkUint64* address, hkUint64 oldValue, hkUint64 newValue)
        {
            return _InterlockedCompareExchange64((__int64*)address, (__int64)newValue, (__int64)oldValue) == (__int64)oldValue;
        }

        template <>
        HK_INLINE hkUint64 HK_CALL compareAndSwapVal<8>(hkUint64* address, hkUint64 oldValue, hkUint64 newValue)
        {
            return (hkUint64)_InterlockedCompareExchange64((__int64*)address, (__int64)newValue, (__int64)oldValue);
        }

        template <>
        HK_INLINE hkUint32 exchangeAdd<4>(hkUint32* address, hkUint32 b)
        {
            return (hkUint32)_InterlockedExchangeAdd((long*)address, (long)b);
        }

        template <>
        HK_INLINE hkUint8 swap<1>(hkUint8* address, hkUint8 newValue)
        {
            return (hkUint8)_InterlockedExchange8((char*)address, (char)newValue);
        }

        template <>
        HK_INLINE hkUint16 swap<2>(hkUint16* address, hkUint16 newValue)
        {
            return (hkUint16)_InterlockedExchange16((short*)address, (short)newValue);
        }

        template <>
        HK_INLINE hkUint32 swap<4>(hkUint32* address, hkUint32 newValue)
        {
            return (hkUint32)_InterlockedExchange((long*)address, (long)newValue);
        }

#ifdef HK_ARCH_X64
#define HK_NATIVE_ATOMIC_ADD64
        template <>
        HK_INLINE hkUint64 exchangeAdd<8>(hkUint64* address, hkUint64 b)
        {
            return (__int64)_InterlockedExchangeAdd64((__int64*)address, (__int64)b);
        }

        template <>
        HK_INLINE hkUint64 swap<8>(hkUint64* address, hkUint64 newValue)
        {
            return (hkUint64)_InterlockedExchange64((__int64*)address, (__int64)newValue);
        }
#endif

        template <int size>
        HK_ALWAYS_INLINE typename Storage<size>::Type loadRelaxed(const typename Storage<size>::Type* address)
        {
            typedef typename Storage<size>::Type StorageType;
            return *reinterpret_cast<const volatile StorageType*>(address);
        }

        template <int size>
        HK_ALWAYS_INLINE typename Storage<size>::Type loadAcquire(const typename Storage<size>::Type* address)
        {
            auto ret = loadRelaxed<size>(address);
            readWriteBarrier();
            return ret;
        }

        template <int size>
        HK_ALWAYS_INLINE typename Storage<size>::Type loadSeqCst(const typename Storage<size>::Type* address)
        {
            readWriteBarrier();
            auto ret = loadRelaxed<size>(address);
            readWriteBarrier();
            return ret;
        }

        template <int size>
        HK_ALWAYS_INLINE void storeRelaxed(typename Storage<size>::Type* address, typename Storage<size>::Type value)
        {
            typedef typename Storage<size>::Type StorageType;
            *reinterpret_cast<volatile StorageType*>(address) = value;
        }

        template <int size>
        HK_ALWAYS_INLINE void storeRelease(typename Storage<size>::Type* address, typename Storage<size>::Type value)
        {
            readWriteBarrier();
            storeRelaxed<size>(address, value);
        }

        template <int size>
        HK_ALWAYS_INLINE void storeSeqCst(typename Storage<size>::Type* address, typename Storage<size>::Type value)
        {
            readWriteBarrier();
            storeRelaxed<size>(address, value);
            readWriteBarrier();
        }
    }

    HK_INLINE void pauseTicks( int numTicks )
    {
        for (int n = numTicks; n > 0; n--)
        {
#if defined ( HK_ARCH_ARM )
    #if defined ( HK_ARCH_ARM_64 )
            __dmb(_ARM64_BARRIER_ISHST);
            __yield();
    #else
            __dmb(_ARM_BARRIER_ISHST);
            __yield();
    #endif
#elif defined( HK_ARCH_INTEL )
            _mm_pause();
#else

#endif
        }
    }

    HK_INLINE void readWriteBarrier()
    {
#if defined ( HK_ARCH_X64 )
        __faststorefence();
#elif defined ( HK_ARCH_ARM_64 )
        __dmb(_ARM64_BARRIER_SY);
#elif defined ( HK_ARCH_ARM )
        __dmb(_ARM_BARRIER_SY);
#elif defined( HK_PLATFORM_XBOX360 )
        MemoryBarrier();
#else
        long Barrier;
        __asm
        {
            xchg Barrier, eax
        }
#endif
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
